/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.schedule;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.alarm.Alarm;
import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.alarm.SnailJobAlarmFactory;
import com.aizuda.snailjob.common.core.enums.RetryNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.EnvironmentUtils;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.NetUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.schedule.AbstractSchedule;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.retry.task.dto.NotifyConfigPartitionTask;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.persistence.mapper.NotifyRecipientMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyRecipient;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryDeadLetter;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class RetryErrorMoreThresholdAlarmSchedule
extends AbstractSchedule
implements Lifecycle {
    private static final String retryErrorMoreThresholdTextMessageFormatter = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" color=#ff0000 size=4>{}\u73af\u5883 \u573a\u666f\u91cd\u8bd5\u5931\u8d25\u6570\u91cf\u8d85\u8fc7{}\u4e2a</font>  \n> \u7a7a\u95f4ID:{}  \n> \u7ec4\u540d\u79f0:{}  \n> \u573a\u666f\u540d\u79f0:{}  \n> \u65f6\u95f4\u7a97\u53e3:{} ~ {}  \n> **\u5171\u8ba1:{}**  \n";
    private final AccessTemplate accessTemplate;
    private final NotifyRecipientMapper recipientMapper;

    public void start() {
        this.taskScheduler.scheduleWithFixedDelay(() -> ((RetryErrorMoreThresholdAlarmSchedule)this).execute(), Instant.now(), Duration.parse("PT10M"));
    }

    public void close() {
    }

    protected void doExecute() {
        SnailJobLog.LOCAL.info("retryErrorMoreThreshold time[{}] ip:[{}]", new Object[]{LocalDateTime.now(), NetUtil.getLocalIpStr()});
        PartitionTaskUtils.process(this::getNotifyConfigPartitions, this::doHandler, (long)0L);
    }

    private void doHandler(List<? extends PartitionTask> partitionTasks) {
        for (PartitionTask partitionTask : partitionTasks) {
            this.doSendAlarm((NotifyConfigPartitionTask)partitionTask);
        }
    }

    private void doSendAlarm(NotifyConfigPartitionTask partitionTask) {
        LocalDateTime now = LocalDateTime.now();
        TaskAccess retryDeadLetterAccess = this.accessTemplate.getRetryDeadLetterAccess();
        long count = retryDeadLetterAccess.count(partitionTask.getGroupName(), partitionTask.getNamespaceId(), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().between(CreateDt::getCreateDt, (Object)now.minusMinutes(30L), (Object)now)).eq(RetryDeadLetter::getGroupName, (Object)partitionTask.getGroupName())).eq(RetryDeadLetter::getSceneName, (Object)partitionTask.getBusinessId()));
        if (count >= (long)partitionTask.getNotifyThreshold().intValue()) {
            List<NotifyConfigPartitionTask.RecipientInfo> recipientInfos = partitionTask.getRecipientInfos();
            for (NotifyConfigPartitionTask.RecipientInfo recipientInfo : recipientInfos) {
                if (Objects.isNull(recipientInfo)) continue;
                AlarmContext context = AlarmContext.build().text(retryErrorMoreThresholdTextMessageFormatter, new Object[]{EnvironmentUtils.getActiveProfile(), count, partitionTask.getNamespaceId(), partitionTask.getGroupName(), partitionTask.getBusinessId(), DateUtils.format((LocalDateTime)now.minusMinutes(30L), (DateTimeFormatter)DateUtils.NORM_DATETIME_PATTERN), DateUtils.toNowFormat((DateTimeFormatter)DateUtils.NORM_DATETIME_PATTERN), count}).title("{}\u73af\u5883 \u573a\u666f\u91cd\u8bd5\u5931\u8d25\u6570\u91cf\u8d85\u8fc7\u9608\u503c", new Object[]{EnvironmentUtils.getActiveProfile()}).notifyAttribute(recipientInfo.getNotifyAttribute());
                Alarm alarmType = SnailJobAlarmFactory.getAlarmType((Integer)recipientInfo.getNotifyType());
                alarmType.asyncSendMessage((Object)context);
            }
        }
    }

    private List<NotifyConfigPartitionTask> getNotifyConfigPartitions(Long startId) {
        List notifyConfigs = this.accessTemplate.getNotifyConfigAccess().listPage(new PageDTO(0L, 1000L), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().gt(NotifyConfig::getId, (Object)startId)).eq(NotifyConfig::getNotifyStatus, (Object)StatusEnum.YES.getStatus())).eq(NotifyConfig::getNotifyScene, (Object)RetryNotifySceneEnum.MAX_RETRY_ERROR.getNotifyScene())).orderByAsc(NotifyConfig::getId)).getRecords();
        if (CollUtil.isEmpty((Collection)notifyConfigs)) {
            return Lists.newArrayList();
        }
        Set recipientIds = notifyConfigs.stream().map(config -> new HashSet(JsonUtil.parseList((String)config.getRecipientIds(), Long.class))).reduce((a, b) -> {
            HashSet set = Sets.newHashSet();
            set.addAll(a);
            set.addAll(b);
            return set;
        }).orElse(new HashSet());
        if (CollUtil.isEmpty((Collection)recipientIds)) {
            return Lists.newArrayList();
        }
        List notifyRecipients = this.recipientMapper.selectBatchIds((Collection)recipientIds);
        Map recipientMap = StreamUtils.toIdentityMap((Collection)notifyRecipients, NotifyRecipient::getId);
        List<NotifyConfigPartitionTask> notifyConfigPartitionTasks = RetryTaskConverter.INSTANCE.toNotifyConfigPartitionTask(notifyConfigs);
        for (NotifyConfigPartitionTask notifyConfigPartitionTask : notifyConfigPartitionTasks) {
            List recipientList = StreamUtils.toList(notifyConfigPartitionTask.getRecipientIds(), recipientId -> {
                NotifyRecipient notifyRecipient = (NotifyRecipient)recipientMap.get(recipientId);
                if (Objects.isNull(notifyRecipient)) {
                    return null;
                }
                NotifyConfigPartitionTask.RecipientInfo recipientInfo = new NotifyConfigPartitionTask.RecipientInfo();
                recipientInfo.setNotifyType(notifyRecipient.getNotifyType());
                recipientInfo.setNotifyAttribute(notifyRecipient.getNotifyAttribute());
                return recipientInfo;
            });
            notifyConfigPartitionTask.setRecipientInfos(recipientList);
        }
        return notifyConfigPartitionTasks;
    }

    public String lockName() {
        return "retryErrorMoreThreshold";
    }

    public String lockAtMost() {
        return "PT10M";
    }

    public String lockAtLeast() {
        return "PT1M";
    }

    @Generated
    public RetryErrorMoreThresholdAlarmSchedule(AccessTemplate accessTemplate, NotifyRecipientMapper recipientMapper) {
        this.accessTemplate = accessTemplate;
        this.recipientMapper = recipientMapper;
    }
}

