/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.retry;

import akka.actor.ActorRef;
import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.common.dto.RetryLogMetaDTO;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.support.FilterStrategy;
import com.aizuda.snailjob.server.retry.task.support.RetryContext;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.StopStrategy;
import java.util.List;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryExecutor<V> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryExecutor.class);
    private final List<StopStrategy> stopStrategies;
    private final WaitStrategy waitStrategy;
    private final List<FilterStrategy> filterStrategies;
    private final RetryContext<V> retryContext;

    public RetryExecutor(List<StopStrategy> stopStrategies, WaitStrategy waitStrategy, List<FilterStrategy> filterStrategies, RetryContext<V> retryContext) {
        this.stopStrategies = stopStrategies;
        this.waitStrategy = waitStrategy;
        this.filterStrategies = filterStrategies;
        this.retryContext = retryContext;
    }

    public Pair<Boolean, StringBuilder> filter() {
        for (FilterStrategy filterStrategy : this.filterStrategies) {
            Pair<Boolean, StringBuilder> pair = filterStrategy.filter(this.retryContext);
            if (((Boolean)pair.getKey()).booleanValue()) continue;
            return pair;
        }
        return Pair.of((Object)Boolean.TRUE, (Object)new StringBuilder());
    }

    public V call(Callable<V> callable) throws Exception {
        V call = null;
        try {
            call = callable.call();
            this.retryContext.setCallResult(call);
        }
        catch (Exception e) {
            RetryLogMetaDTO retryLogMetaDTO = RetryTaskConverter.INSTANCE.toLogMetaDTO(this.retryContext.getRetryTask());
            retryLogMetaDTO.setTimestamp(Long.valueOf(DateUtils.toNowMilli()));
            SnailJobLog.REMOTE.error("\u8bf7\u6c42\u5ba2\u6237\u7aef\u6267\u884c\u5931\u8d25. uniqueId:[{}] <|>{}<|>", new Object[]{this.retryContext.getRetryTask().getUniqueId(), e});
            this.retryContext.setException(e);
        }
        boolean isStop = Boolean.TRUE;
        for (StopStrategy stopStrategy : this.stopStrategies) {
            if (!stopStrategy.supports(this.retryContext) || stopStrategy.shouldStop(this.retryContext)) continue;
            isStop = Boolean.FALSE;
        }
        ActorRef actorRef = isStop ? ActorGenerator.finishActor() : ActorGenerator.failureActor();
        actorRef.tell((Object)this.retryContext.getRetryTask(), actorRef);
        return call;
    }

    public RetryContext<V> getRetryContext() {
        return this.retryContext;
    }
}

