/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.log;

import akka.actor.ActorRef;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.dto.LogContentDTO;
import com.aizuda.snailjob.common.log.dto.TaskLogFieldDTO;
import com.aizuda.snailjob.common.log.enums.LogTypeEnum;
import com.aizuda.snailjob.server.common.LogStorage;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.common.dto.LogMetaDTO;
import com.aizuda.snailjob.server.common.dto.RetryLogMetaDTO;
import com.aizuda.snailjob.server.common.log.LogStorageFactory;
import com.aizuda.snailjob.server.retry.task.support.dispatch.actor.log.RetryTaskLogDTO;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class RetryLogStorage
implements LogStorage,
InitializingBean {
    public LogTypeEnum logType() {
        return LogTypeEnum.RETRY;
    }

    public void storage(LogContentDTO logContentDTO, LogMetaDTO logMetaDTO) {
        RetryLogMetaDTO retryLogMetaDTO = (RetryLogMetaDTO)logMetaDTO;
        RetryTaskLogDTO retryTaskLogDTO = new RetryTaskLogDTO();
        Map<String, String> messageMap = logContentDTO.getFieldList().stream().filter(logTaskDTO_ -> !Objects.isNull(logTaskDTO_.getValue())).collect(Collectors.toMap(TaskLogFieldDTO::getName, TaskLogFieldDTO::getValue));
        retryTaskLogDTO.setMessage(JsonUtil.toJsonString((Object)Lists.newArrayList((Object[])new Map[]{messageMap})));
        retryTaskLogDTO.setGroupName(retryLogMetaDTO.getGroupName());
        retryTaskLogDTO.setNamespaceId(retryLogMetaDTO.getNamespaceId());
        retryTaskLogDTO.setUniqueId(retryLogMetaDTO.getUniqueId());
        retryTaskLogDTO.setRealTime(retryLogMetaDTO.getTimestamp());
        ActorRef actorRef = ActorGenerator.logActor();
        actorRef.tell((Object)retryTaskLogDTO, actorRef);
    }

    public void afterPropertiesSet() throws Exception {
        LogStorageFactory.register((LogTypeEnum)this.logType(), (LogStorage)this);
    }
}

