/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.timer;

import com.aizuda.snailjob.common.core.context.SpringContext;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.server.retry.task.support.dispatch.task.TaskActuatorFactory;
import com.aizuda.snailjob.server.retry.task.support.dispatch.task.TaskExecutor;
import com.aizuda.snailjob.server.retry.task.support.timer.AbstractTimerTask;
import com.aizuda.snailjob.server.retry.task.support.timer.RetryTimerContext;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.netty.util.Timeout;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryTimerTask
extends AbstractTimerTask {
    private static final Logger log = LoggerFactory.getLogger(RetryTimerTask.class);
    private RetryTimerContext context;

    public RetryTimerTask(RetryTimerContext context) {
        this.context = context;
        this.groupName = context.getGroupName();
        this.uniqueId = context.getUniqueId();
        this.namespaceId = context.getNamespaceId();
    }

    @Override
    public void doRun(Timeout timeout) {
        AccessTemplate accessTemplate = (AccessTemplate)SpringContext.getBeanByType(AccessTemplate.class);
        TaskAccess retryTaskAccess = accessTemplate.getRetryTaskAccess();
        RetryTask retryTask = (RetryTask)retryTaskAccess.one(this.context.getGroupName(), this.context.getNamespaceId(), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)this.context.getNamespaceId())).eq(RetryTask::getGroupName, (Object)this.context.getGroupName())).eq(RetryTask::getUniqueId, (Object)this.context.getUniqueId())).eq(RetryTask::getRetryStatus, (Object)RetryStatusEnum.RUNNING.getStatus()));
        if (Objects.isNull(retryTask)) {
            return;
        }
        TaskExecutor taskExecutor = TaskActuatorFactory.getTaskActuator(this.context.getScene());
        taskExecutor.actuator(retryTask);
    }

    public RetryTimerContext getContext() {
        return this.context;
    }

    public void setContext(RetryTimerContext context) {
        this.context = context;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetryTimerTask)) {
            return false;
        }
        RetryTimerTask other = (RetryTimerTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RetryTimerContext this$context = this.getContext();
        RetryTimerContext other$context = other.getContext();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RetryTimerTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RetryTimerContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }

    public String toString() {
        return "RetryTimerTask(context=" + this.getContext() + ")";
    }
}

