/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.strategy;

import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.common.core.context.SpringContext;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.IdempotentStrategy;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.dto.DistributeInstance;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.retry.task.support.FilterStrategy;
import com.aizuda.snailjob.server.retry.task.support.RetryContext;
import com.aizuda.snailjob.server.retry.task.support.cache.CacheGroupRateLimiter;
import com.aizuda.snailjob.template.datasource.persistence.mapper.ServerNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.aizuda.snailjob.template.datasource.persistence.po.ServerNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.util.concurrent.RateLimiter;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterStrategies {
    private static final Logger log = LoggerFactory.getLogger(FilterStrategies.class);

    private FilterStrategies() {
    }

    @Deprecated
    public static FilterStrategy triggerAtFilter() {
        return new TriggerAtFilterStrategies();
    }

    public static FilterStrategy bitSetIdempotentFilter(IdempotentStrategy<Pair<String, String>, Long> idempotentStrategy) {
        return new BitSetIdempotentFilterStrategies(idempotentStrategy);
    }

    public static FilterStrategy sceneBlackFilter() {
        return new SceneBlackFilterStrategies();
    }

    public static FilterStrategy checkAliveClientPodFilter() {
        return new CheckAliveClientPodFilterStrategies();
    }

    public static FilterStrategy rateLimiterFilter() {
        return new RateLimiterFilterStrategies();
    }

    public static FilterStrategy rebalanceFilterStrategies() {
        return new ReBalanceFilterStrategies();
    }

    private static final class TriggerAtFilterStrategies
    implements FilterStrategy {
        private TriggerAtFilterStrategies() {
        }

        @Override
        public Pair<Boolean, StringBuilder> filter(RetryContext retryContext) {
            RetryTask retryTask = retryContext.getRetryTask();
            LocalDateTime nextTriggerAt = retryTask.getNextTriggerAt();
            boolean result = nextTriggerAt.isBefore(LocalDateTime.now());
            StringBuilder description = new StringBuilder();
            if (!result) {
                description.append(MessageFormat.format("\u672a\u5230\u89e6\u53d1\u65f6\u95f4. uniqueId:[{0}]", retryTask.getUniqueId()));
            }
            return Pair.of((Object)result, (Object)description);
        }

        @Override
        public int order() {
            return 0;
        }
    }

    private static final class BitSetIdempotentFilterStrategies
    implements FilterStrategy {
        private IdempotentStrategy<Pair<String, String>, Long> idempotentStrategy;

        public BitSetIdempotentFilterStrategies(IdempotentStrategy<Pair<String, String>, Long> idempotentStrategy) {
            this.idempotentStrategy = idempotentStrategy;
        }

        @Override
        public Pair<Boolean, StringBuilder> filter(RetryContext retryContext) {
            RetryTask retryTask = retryContext.getRetryTask();
            boolean result = !this.idempotentStrategy.isExist((Object)Pair.of((Object)retryTask.getGroupName(), (Object)retryTask.getNamespaceId()), (Object)retryTask.getId());
            StringBuilder description = new StringBuilder();
            if (!result) {
                description.append(MessageFormat.format("\u5b58\u5728\u6267\u884c\u4e2d\u7684\u4efb\u52a1.uniqueId:[{0}]", retryTask.getUniqueId()));
            }
            return Pair.of((Object)result, (Object)description);
        }

        @Override
        public int order() {
            return 1;
        }
    }

    private static final class SceneBlackFilterStrategies
    implements FilterStrategy {
        private SceneBlackFilterStrategies() {
        }

        @Override
        public Pair<Boolean, StringBuilder> filter(RetryContext retryContext) {
            RetryTask retryTask = retryContext.getRetryTask();
            boolean result = !retryContext.getSceneBlacklist().contains(retryTask.getSceneName());
            StringBuilder description = new StringBuilder();
            if (!result) {
                description.append(MessageFormat.format("\u573a\u666f:[{0}]\u5728\u9ed1\u540d\u5355\u4e2d, \u4e0d\u5141\u8bb8\u6267\u884c.", retryTask.getSceneName()));
            }
            return Pair.of((Object)result, (Object)description);
        }

        @Override
        public int order() {
            return 2;
        }
    }

    private static final class CheckAliveClientPodFilterStrategies
    implements FilterStrategy {
        private CheckAliveClientPodFilterStrategies() {
        }

        @Override
        public Pair<Boolean, StringBuilder> filter(RetryContext retryContext) {
            boolean result;
            RetryTask retryTask = retryContext.getRetryTask();
            RegisterNodeInfo serverNode = retryContext.getServerNode();
            StringBuilder description = new StringBuilder();
            if (Objects.isNull(serverNode)) {
                return Pair.of((Object)Boolean.FALSE, (Object)description.append(MessageFormat.format("\u6ca1\u6709\u53ef\u6267\u884c\u7684\u5ba2\u6237\u7aef\u8282\u70b9. uniqueId:[{0}]", retryTask.getUniqueId())));
            }
            ServerNodeMapper serverNodeMapper = (ServerNodeMapper)SpringContext.getBeanByType(ServerNodeMapper.class);
            boolean bl = result = 1L == serverNodeMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(ServerNode::getHostId, (Object)serverNode.getHostId()));
            if (!result) {
                CacheRegisterTable.remove((String)retryTask.getGroupName(), (String)retryTask.getNamespaceId(), (String)serverNode.getHostId());
                description.append(MessageFormat.format("DB\u4e2d\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u7aef\u8282\u70b9. hostId:[{0}] uniqueId:[{1}]", serverNode.getHostId(), retryTask.getUniqueId()));
            }
            return Pair.of((Object)result, (Object)description);
        }

        @Override
        public int order() {
            return 3;
        }
    }

    private static final class RateLimiterFilterStrategies
    implements FilterStrategy {
        private RateLimiterFilterStrategies() {
        }

        @Override
        public Pair<Boolean, StringBuilder> filter(RetryContext retryContext) {
            RegisterNodeInfo serverNode = retryContext.getServerNode();
            RetryTask retryTask = retryContext.getRetryTask();
            StringBuilder description = new StringBuilder();
            Boolean result = Boolean.TRUE;
            RateLimiter rateLimiter = CacheGroupRateLimiter.getRateLimiterByKey(serverNode.getHostId());
            if (Objects.nonNull(rateLimiter) && !rateLimiter.tryAcquire(100L, TimeUnit.MILLISECONDS)) {
                SnailJobLog.LOCAL.error("\u8be5POD:[{}]\u5df2\u5230\u8fbe\u6700\u5927\u9650\u6d41\u9608\u503c\uff0c\u672c\u6b21\u91cd\u8bd5\u4e0d\u6267\u884c", new Object[]{serverNode.getHostId()});
                description.append(MessageFormat.format("\u8be5POD:[{0}]\u5df2\u5230\u8fbe\u6700\u5927\u9650\u6d41\u9608\u503c\uff0c\u672c\u6b21\u91cd\u8bd5\u4e0d\u6267\u884c.uniqueId:[{1}]", serverNode.getHostId(), retryTask.getUniqueId()));
                result = Boolean.FALSE;
            }
            return Pair.of((Object)result, (Object)description);
        }

        @Override
        public int order() {
            return 4;
        }
    }

    private static final class ReBalanceFilterStrategies
    implements FilterStrategy {
        private ReBalanceFilterStrategies() {
        }

        @Override
        public Pair<Boolean, StringBuilder> filter(RetryContext retryContext) {
            RetryTask retryTask = retryContext.getRetryTask();
            boolean result = !DistributeInstance.RE_BALANCE_ING.get();
            StringBuilder description = new StringBuilder();
            if (!result) {
                description.append(MessageFormat.format("\u7cfb\u7edfRebalancing\u4e2d\u6570\u636e\u65e0\u6cd5\u91cd\u8bd5.uniqueId:[{0}]", retryTask.getUniqueId()));
            }
            return Pair.of((Object)result, (Object)description);
        }

        @Override
        public int order() {
            return 1;
        }
    }
}

