/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.schedule;

import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.schedule.AbstractSchedule;
import com.aizuda.snailjob.server.retry.task.service.RetryService;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RetryTaskSchedule
extends AbstractSchedule
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(RetryTaskSchedule.class);
    private final RetryService retryService;
    @Autowired
    protected AccessTemplate accessTemplate;

    public void start() {
        this.taskScheduler.scheduleWithFixedDelay(() -> ((RetryTaskSchedule)this).execute(), Instant.now(), Duration.parse("PT1H"));
    }

    public void close() {
    }

    protected void doExecute() {
        try {
            Set groupNameList = this.accessTemplate.getGroupConfigAccess().list((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{GroupConfig::getGroupName, GroupConfig::getNamespaceId}).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus())).stream().map(groupConfig -> Pair.of((Object)groupConfig.getGroupName(), (Object)groupConfig.getNamespaceId())).collect(Collectors.toSet());
            for (Pair pair : groupNameList) {
                this.retryService.moveDeadLetterAndDelFinish((String)pair.getKey(), (String)pair.getValue());
            }
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("clearFinishAndMoveDeadLetterRetryTask \u5931\u8d25", new Object[]{e});
        }
    }

    public String lockName() {
        return "clearFinishAndMoveDeadLetterRetryTask";
    }

    public String lockAtMost() {
        return "PT60s";
    }

    public String lockAtLeast() {
        return "PT60s";
    }

    public RetryTaskSchedule(RetryService retryService) {
        this.retryService = retryService;
    }
}

