/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.idempotent;

import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.server.common.IdempotentStrategy;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerIdempotent
implements IdempotentStrategy<Pair<String, String>, String> {
    private static final Logger log = LoggerFactory.getLogger(TimerIdempotent.class);
    private static final String KEY_FORMAT = "{0}_{1}_{2}";
    private static final Cache<String, String> cache = CacheBuilder.newBuilder().concurrencyLevel(16).expireAfterWrite(20L, TimeUnit.SECONDS).build();

    public boolean set(Pair<String, String> pair, String value) {
        cache.put((Object)TimerIdempotent.getKey(pair, value), (Object)value);
        return Boolean.TRUE;
    }

    private static String getKey(Pair<String, String> pair, String value) {
        return MessageFormat.format(KEY_FORMAT, pair.getKey(), pair.getValue(), value);
    }

    public String get(Pair<String, String> pair) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
    }

    public boolean isExist(Pair<String, String> pair, String value) {
        return cache.asMap().containsKey(TimerIdempotent.getKey(pair, value));
    }

    public boolean clear(Pair<String, String> pair, String value) {
        cache.invalidate((Object)TimerIdempotent.getKey(pair, value));
        return Boolean.TRUE;
    }
}

