/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.idempotent;

import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.server.common.IdempotentStrategy;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class RetryIdempotentStrategyHandler
implements IdempotentStrategy<Pair<String, String>, Long> {
    private static final String KEY_FORMAT = "{0}_{1}_{2}";
    private static final Cache<String, Long> cache = CacheBuilder.newBuilder().concurrencyLevel(16).expireAfterWrite(60L, TimeUnit.SECONDS).build();

    public boolean set(Pair<String, String> pair, Long value) {
        cache.put((Object)RetryIdempotentStrategyHandler.getKey(pair, value), (Object)value);
        return Boolean.TRUE;
    }

    public Long get(Pair<String, String> pair) {
        throw new SnailJobServerException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c");
    }

    public boolean isExist(Pair<String, String> pair, Long value) {
        return cache.asMap().containsKey(RetryIdempotentStrategyHandler.getKey(pair, value));
    }

    public boolean clear(Pair<String, String> pair, Long value) {
        cache.invalidate((Object)RetryIdempotentStrategyHandler.getKey(pair, value));
        return Boolean.TRUE;
    }

    private static String getKey(Pair<String, String> pair, Long value) {
        return MessageFormat.format(KEY_FORMAT, pair.getKey(), pair.getValue(), value);
    }
}

