/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch.task;

import akka.actor.ActorRef;
import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.IdempotentStrategy;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.dto.RetryLogMetaDTO;
import com.aizuda.snailjob.server.common.handler.ClientNodeAllocateHandler;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.support.RetryContext;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.dispatch.task.TaskActuatorFactory;
import com.aizuda.snailjob.server.retry.task.support.dispatch.task.TaskExecutor;
import com.aizuda.snailjob.server.retry.task.support.retry.RetryExecutor;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractTaskExecutor
implements TaskExecutor,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractTaskExecutor.class);
    @Autowired
    @Qualifier(value="retryIdempotentStrategyHandler")
    protected IdempotentStrategy<Pair<String, String>, Long> idempotentStrategy;
    @Autowired
    protected SystemProperties systemProperties;
    @Autowired
    protected AccessTemplate accessTemplate;
    @Autowired
    protected ClientNodeAllocateHandler clientNodeAllocateHandler;

    @Override
    public void actuator(RetryTask retryTask) {
        this.retryCountIncrement(retryTask);
        RetrySceneConfig retrySceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(retryTask.getGroupName(), retryTask.getSceneName(), retryTask.getNamespaceId());
        RetryContext retryContext = this.builderRetryContext(retryTask.getGroupName(), retryTask, retrySceneConfig);
        RetryExecutor executor = this.builderResultRetryExecutor(retryContext, retrySceneConfig);
        if (!this.preCheck(retryContext, executor)) {
            return;
        }
        this.productExecUnitActor(executor);
    }

    protected boolean preCheck(RetryContext retryContext, RetryExecutor executor) {
        Pair<Boolean, StringBuilder> pair = executor.filter();
        if (!((Boolean)pair.getKey()).booleanValue()) {
            RetryTask retryTask = retryContext.getRetryTask();
            log.warn("\u5f53\u524d\u4efb\u52a1\u4e0d\u6ee1\u8db3\u6267\u884c\u6761\u4ef6. groupName:[{}] uniqueId:[{}], description:[{}]", new Object[]{retryTask.getGroupName(), retryTask.getUniqueId(), ((StringBuilder)pair.getValue()).toString()});
            RetryLogMetaDTO retryLogMetaDTO = RetryTaskConverter.INSTANCE.toLogMetaDTO(retryTask);
            retryLogMetaDTO.setTimestamp(Long.valueOf(DateUtils.toNowMilli()));
            SnailJobLog.REMOTE.error("\u89e6\u53d1\u6761\u4ef6\u4e0d\u6ee1\u8db3 \u539f\u56e0: [{}] <|>{}<|>", new Object[]{((StringBuilder)pair.getValue()).toString(), retryLogMetaDTO});
            return false;
        }
        return true;
    }

    private void retryCountIncrement(RetryTask retryTask) {
        Integer retryCount = retryTask.getRetryCount();
        retryCount = retryCount + 1;
        retryTask.setRetryCount(retryCount);
    }

    protected void productExecUnitActor(RetryExecutor retryExecutor) {
        RetryTask retryTask = retryExecutor.getRetryContext().getRetryTask();
        String groupName = retryTask.getGroupName();
        String namespaceId = retryTask.getNamespaceId();
        Long retryId = retryExecutor.getRetryContext().getRetryTask().getId();
        this.idempotentStrategy.set((Object)Pair.of((Object)groupName, (Object)namespaceId), (Object)retryId);
        ActorRef actorRef = this.getActorRef();
        actorRef.tell((Object)retryExecutor, actorRef);
    }

    protected abstract RetryContext builderRetryContext(String var1, RetryTask var2, RetrySceneConfig var3);

    protected abstract RetryExecutor builderResultRetryExecutor(RetryContext var1, RetrySceneConfig var2);

    protected abstract ActorRef getActorRef();

    public void afterPropertiesSet() throws Exception {
        TaskActuatorFactory.register(this.getTaskType(), this);
    }
}

