/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.generator.task;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.enums.DelayLevelEnum;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.generator.id.IdGenerator;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.retry.task.generator.task.TaskContext;
import com.aizuda.snailjob.server.retry.task.generator.task.TaskGenerator;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskLogConverter;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLog;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public abstract class AbstractGenerator
implements TaskGenerator {
    private static final Logger log = LoggerFactory.getLogger(AbstractGenerator.class);
    @Autowired
    protected AccessTemplate accessTemplate;
    @Autowired
    private List<IdGenerator> idGeneratorList;
    @Autowired
    private RetryTaskLogMapper retryTaskLogMapper;

    @Override
    @Transactional
    public void taskGenerator(TaskContext taskContext) {
        SnailJobLog.LOCAL.debug("received report data. {}", new Object[]{JsonUtil.toJsonString((Object)taskContext)});
        RetrySceneConfig retrySceneConfig = this.checkAndInitScene(taskContext);
        List taskInfos = taskContext.getTaskInfos().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TaskContext.TaskInfo>(Comparator.comparing(TaskContext.TaskInfo::getIdempotentId))), ArrayList::new));
        Set idempotentIdSet = taskInfos.stream().map(TaskContext.TaskInfo::getIdempotentId).collect(Collectors.toSet());
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryTaskAccess();
        List retryTasks = retryTaskAccess.list(taskContext.getGroupName(), taskContext.getNamespaceId(), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)taskContext.getNamespaceId())).eq(RetryTask::getGroupName, (Object)taskContext.getGroupName())).eq(RetryTask::getSceneName, (Object)taskContext.getSceneName())).eq(RetryTask::getRetryStatus, (Object)RetryStatusEnum.RUNNING.getStatus())).eq(RetryTask::getTaskType, (Object)SyetemTaskTypeEnum.RETRY.getType())).in(RetryTask::getIdempotentId, idempotentIdSet));
        Map<String, List<RetryTask>> retryTaskMap = retryTasks.stream().collect(Collectors.groupingBy(RetryTask::getIdempotentId));
        ArrayList waitInsertTasks = new ArrayList();
        ArrayList waitInsertTaskLogs = new ArrayList();
        LocalDateTime now = LocalDateTime.now();
        for (TaskContext.TaskInfo taskInfo : taskInfos) {
            Pair<List<RetryTask>, List<RetryTaskLog>> pair = this.doConvertTask(retryTaskMap, taskContext, now, taskInfo, retrySceneConfig);
            waitInsertTasks.addAll((Collection)pair.getKey());
            waitInsertTaskLogs.addAll((Collection)pair.getValue());
        }
        if (CollectionUtils.isEmpty(waitInsertTasks)) {
            return;
        }
        Assert.isTrue((waitInsertTasks.size() == retryTaskAccess.batchInsert(taskContext.getGroupName(), taskContext.getNamespaceId(), waitInsertTasks) ? 1 : 0) != 0, () -> new SnailJobServerException("failed to report data"));
        Assert.isTrue((waitInsertTaskLogs.size() == this.retryTaskLogMapper.batchInsert(waitInsertTaskLogs) ? 1 : 0) != 0, () -> new SnailJobServerException("\u65b0\u589e\u91cd\u8bd5\u65e5\u5fd7\u5931\u8d25"));
    }

    private Pair<List<RetryTask>, List<RetryTaskLog>> doConvertTask(Map<String, List<RetryTask>> retryTaskMap, TaskContext taskContext, LocalDateTime now, TaskContext.TaskInfo taskInfo, RetrySceneConfig retrySceneConfig) {
        ArrayList<RetryTask> waitInsertTasks = new ArrayList<RetryTask>();
        ArrayList<RetryTaskLog> waitInsertTaskLogs = new ArrayList<RetryTaskLog>();
        List list = ((List)retryTaskMap.getOrDefault(taskInfo.getIdempotentId(), new ArrayList())).stream().filter(retryTask -> taskContext.getGroupName().equals(retryTask.getGroupName()) && taskContext.getNamespaceId().equals(retryTask.getNamespaceId()) && taskContext.getSceneName().equals(retryTask.getSceneName())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(list)) {
            SnailJobLog.LOCAL.warn("interrupted reporting in retrying task. [{}]", new Object[]{JsonUtil.toJsonString((Object)taskInfo)});
            return Pair.of(waitInsertTasks, waitInsertTaskLogs);
        }
        RetryTask retryTask2 = RetryTaskConverter.INSTANCE.toRetryTask(taskInfo);
        retryTask2.setNamespaceId(taskContext.getNamespaceId());
        retryTask2.setUniqueId(this.getIdGenerator(taskContext.getGroupName(), taskContext.getNamespaceId()));
        retryTask2.setTaskType(SyetemTaskTypeEnum.RETRY.getType());
        retryTask2.setGroupName(taskContext.getGroupName());
        retryTask2.setSceneName(taskContext.getSceneName());
        retryTask2.setRetryStatus(this.initStatus(taskContext));
        retryTask2.setBizNo(Optional.ofNullable(retryTask2.getBizNo()).orElse(""));
        retryTask2.setCreateDt(now);
        retryTask2.setUpdateDt(now);
        if (StrUtil.isBlank((CharSequence)retryTask2.getExtAttrs())) {
            retryTask2.setExtAttrs("");
        }
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setNextTriggerAt(now);
        waitStrategyContext.setTriggerInterval(retrySceneConfig.getTriggerInterval());
        waitStrategyContext.setDelayLevel(Integer.valueOf(1));
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)retrySceneConfig.getBackOff());
        retryTask2.setNextTriggerAt(DateUtils.toLocalDateTime((long)waitStrategy.computeTriggerTime(waitStrategyContext)));
        waitInsertTasks.add(retryTask2);
        RetryTaskLog retryTaskLog = RetryTaskLogConverter.INSTANCE.toRetryTask(retryTask2);
        retryTaskLog.setTaskType(SyetemTaskTypeEnum.RETRY.getType());
        retryTaskLog.setCreateDt(now);
        waitInsertTaskLogs.add(retryTaskLog);
        return Pair.of(waitInsertTasks, waitInsertTaskLogs);
    }

    protected abstract Integer initStatus(TaskContext var1);

    private RetrySceneConfig checkAndInitScene(TaskContext taskContext) {
        RetrySceneConfig retrySceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(taskContext.getGroupName(), taskContext.getSceneName(), taskContext.getNamespaceId());
        if (Objects.isNull(retrySceneConfig)) {
            GroupConfig groupConfig = this.accessTemplate.getGroupConfigAccess().getGroupConfigByGroupName(taskContext.getGroupName(), taskContext.getNamespaceId());
            if (Objects.isNull(groupConfig)) {
                throw new SnailJobServerException("failed to report data, no group configuration found. groupName:[{}]", new Object[]{taskContext.getGroupName()});
            }
            if (groupConfig.getInitScene().equals(StatusEnum.NO.getStatus())) {
                throw new SnailJobServerException("failed to report data, no scene configuration found. groupName:[{}] sceneName:[{}]", new Object[]{taskContext.getGroupName(), taskContext.getSceneName()});
            }
            retrySceneConfig = this.initScene(taskContext.getGroupName(), taskContext.getSceneName(), taskContext.getNamespaceId());
        }
        return retrySceneConfig;
    }

    private RetrySceneConfig initScene(String groupName, String sceneName, String namespaceId) {
        RetrySceneConfig retrySceneConfig = new RetrySceneConfig();
        retrySceneConfig.setNamespaceId(namespaceId);
        retrySceneConfig.setGroupName(groupName);
        retrySceneConfig.setSceneName(sceneName);
        retrySceneConfig.setSceneStatus(StatusEnum.YES.getStatus());
        retrySceneConfig.setBackOff(Integer.valueOf(WaitStrategies.WaitStrategyEnum.DELAY_LEVEL.getType()));
        retrySceneConfig.setMaxRetryCount(Integer.valueOf(DelayLevelEnum._21.getLevel()));
        retrySceneConfig.setDescription("\u81ea\u52a8\u521d\u59cb\u5316\u573a\u666f");
        Assert.isTrue((1 == this.accessTemplate.getSceneConfigAccess().insert((Object)retrySceneConfig) ? 1 : 0) != 0, () -> new SnailJobServerException("init scene error"));
        return retrySceneConfig;
    }

    private String getIdGenerator(String groupName, String namespaceId) {
        GroupConfig groupConfig = this.accessTemplate.getGroupConfigAccess().getGroupConfigByGroupName(groupName, namespaceId);
        for (IdGenerator idGenerator : this.idGeneratorList) {
            if (!idGenerator.supports(groupConfig.getIdGeneratorMode().intValue())) continue;
            return idGenerator.idGenerator(groupName, namespaceId);
        }
        throw new SnailJobServerException("id generator mode not configured. [{}]", new Object[]{groupName});
    }
}

