/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.request;

import cn.hutool.core.net.url.UrlQuery;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.cache.CacheConsumerGroup;
import com.aizuda.snailjob.server.common.convert.RegisterNodeInfoConverter;
import com.aizuda.snailjob.server.common.handler.GetHttpRequestHandler;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.register.ClientRegister;
import com.aizuda.snailjob.template.datasource.persistence.po.ServerNode;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class GetRegNodesPostHttpRequestHandler
extends GetHttpRequestHandler {
    private final InstanceManager instanceManager;

    public boolean supports(String path) {
        return "/pull/register/queue/v1".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    public SnailJobRpcResult doHandler(String content, UrlQuery query, HttpHeaders headers) {
        SnailJobLog.LOCAL.debug("Client Callback Request. content:[{}]", new Object[]{content});
        SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        List<ServerNode> refreshCache = this.getAndRefreshCache();
        return new SnailJobRpcResult(refreshCache, retryRequest.getReqId());
    }

    public List<ServerNode> getAndRefreshCache() {
        List expireNodes = ClientRegister.getExpireNodes();
        if (Objects.nonNull(expireNodes)) {
            for (ServerNode serverNode : expireNodes) {
                serverNode.setExpireAt(LocalDateTime.now().plusSeconds(30L));
                this.instanceManager.registerOrUpdate(RegisterNodeInfoConverter.INSTANCE.toRegisterNodeInfo(serverNode));
                CacheConsumerGroup.addOrUpdate((String)serverNode.getGroupName(), (String)serverNode.getNamespaceId());
            }
        }
        return expireNodes;
    }

    @Generated
    public GetRegNodesPostHttpRequestHandler(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }
}

