/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.callback;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.RandomUtil;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.InstanceLiveInfo;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.job.task.dto.JobExecutorResultDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.callback.AbstractClientCallbackHandler;
import com.aizuda.snailjob.server.job.task.support.callback.ClientCallbackContext;
import java.util.Collection;
import java.util.Set;
import lombok.Generated;
import org.apache.pekko.actor.ActorRef;
import org.springframework.stereotype.Component;

@Component
public class ShardingClientCallbackHandler
extends AbstractClientCallbackHandler {
    private final InstanceManager instanceManager;

    @Override
    public JobTaskTypeEnum getTaskInstanceType() {
        return JobTaskTypeEnum.SHARDING;
    }

    @Override
    protected void doCallback(ClientCallbackContext context) {
        JobExecutorResultDTO jobExecutorResultDTO = JobTaskConverter.INSTANCE.toJobExecutorResultDTO(context);
        jobExecutorResultDTO.setTaskId(context.getTaskId());
        jobExecutorResultDTO.setMessage(context.getExecuteResult().getMessage());
        jobExecutorResultDTO.setResult(context.getExecuteResult().getResult());
        jobExecutorResultDTO.setTaskType(this.getTaskInstanceType().getType());
        ActorRef actorRef = ActorGenerator.jobTaskExecutorResultActor();
        actorRef.tell((Object)jobExecutorResultDTO, actorRef);
    }

    @Override
    protected String chooseNewClient(ClientCallbackContext context) {
        Set instanceALiveInfoSet = this.instanceManager.getInstanceALiveInfoSet(context.getNamespaceId(), context.getGroupName(), context.getLabels());
        Set nodes = StreamUtils.toSet((Collection)instanceALiveInfoSet, InstanceLiveInfo::getNodeInfo);
        if (CollUtil.isEmpty((Collection)nodes)) {
            SnailJobLog.LOCAL.error("No executable client information. Job ID:[{}]", new Object[]{context.getJobId()});
            return null;
        }
        RegisterNodeInfo serverNode = (RegisterNodeInfo)RandomUtil.randomEle((Object[])nodes.toArray(new RegisterNodeInfo[0]));
        return ClientInfoUtils.generate((RegisterNodeInfo)serverNode);
    }

    @Generated
    public ShardingClientCallbackHandler(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }
}

