/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.generator.task;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.job.task.support.generator.task.JobTaskGenerateContext;
import com.aizuda.snailjob.server.job.task.support.generator.task.JobTaskGenerator;
import com.aizuda.snailjob.server.job.task.support.generator.task.JobTaskGeneratorFactory;
import com.aizuda.snailjob.template.datasource.enums.DbTypeEnum;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.utils.DbUtils;
import com.google.common.collect.Sets;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractJobTaskGenerator
implements JobTaskGenerator,
InitializingBean {
    @Autowired
    private JobTaskMapper jobTaskMapper;

    @Override
    public List<JobTask> generate(JobTaskGenerateContext context) {
        return this.doGenerate(context);
    }

    protected abstract List<JobTask> doGenerate(JobTaskGenerateContext var1);

    public void afterPropertiesSet() throws Exception {
        JobTaskGeneratorFactory.registerTaskInstance(this.getTaskInstanceType(), this);
    }

    protected void batchSaveJobTasks(List<JobTask> jobTasks) {
        if (Sets.newHashSet((Object[])new String[]{DbTypeEnum.ORACLE.getDb(), DbTypeEnum.SQLSERVER.getDb()}).contains(DbUtils.getDbType().getDb())) {
            for (JobTask jobTask : jobTasks) {
                Assert.isTrue((1 == this.jobTaskMapper.insert((Object)jobTask) ? 1 : 0) != 0, () -> new SnailJobServerException("Adding new task instance failed"));
            }
        } else {
            Assert.isTrue((jobTasks.size() == this.jobTaskMapper.insertBatch(jobTasks) ? 1 : 0) != 0, () -> new SnailJobServerException("Adding new task instance failed"));
        }
    }
}

