/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.callback;

import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.server.common.dto.InstanceLiveInfo;
import com.aizuda.snailjob.server.common.dto.InstanceSelectCondition;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.job.task.dto.JobExecutorResultDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.callback.AbstractClientCallbackHandler;
import com.aizuda.snailjob.server.job.task.support.callback.ClientCallbackContext;
import java.util.Objects;
import lombok.Generated;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClusterClientCallbackHandler
extends AbstractClientCallbackHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterClientCallbackHandler.class);
    private final InstanceManager instanceManager;

    @Override
    public JobTaskTypeEnum getTaskInstanceType() {
        return JobTaskTypeEnum.CLUSTER;
    }

    @Override
    protected String chooseNewClient(ClientCallbackContext context) {
        InstanceSelectCondition condition = InstanceSelectCondition.builder().allocKey(String.valueOf(context.getJobId())).groupName(context.getGroupName()).namespaceId(context.getNamespaceId()).routeKey(context.getJob().getRouteKey()).targetLabels(context.getJob().getLabels()).build();
        InstanceLiveInfo instance = this.instanceManager.getALiveInstanceByRouteKey(condition);
        if (Objects.isNull(instance)) {
            log.error("No executable client information. Job ID:[{}]", (Object)context.getJobId());
            return null;
        }
        return ClientInfoUtils.generate((RegisterNodeInfo)instance.getNodeInfo());
    }

    @Override
    protected void doCallback(ClientCallbackContext context) {
        JobExecutorResultDTO jobExecutorResultDTO = JobTaskConverter.INSTANCE.toJobExecutorResultDTO(context);
        jobExecutorResultDTO.setTaskId(context.getTaskId());
        jobExecutorResultDTO.setMessage(context.getExecuteResult().getMessage());
        jobExecutorResultDTO.setResult(context.getExecuteResult().getResult());
        jobExecutorResultDTO.setTaskType(this.getTaskInstanceType().getType());
        ActorRef actorRef = ActorGenerator.jobTaskExecutorResultActor();
        actorRef.tell((Object)jobExecutorResultDTO, actorRef);
    }

    @Generated
    public ClusterClientCallbackHandler(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }
}

