/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.request;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.url.UrlQuery;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.JobTriggerDTO;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.support.JobPrepareHandler;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class OpenApiTriggerJobRequestHandler
extends PostHttpRequestHandler {
    private final JobMapper jobMapper;
    private final AccessTemplate accessTemplate;
    private final JobPrepareHandler terminalJobPrepareHandler;

    public boolean supports(String path) {
        return "/api/job/triggerJob".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    public SnailJobRpcResult doHandler(String content, UrlQuery query, HttpHeaders headers) {
        SnailJobLog.LOCAL.debug("Trigger job content:[{}]", new Object[]{content});
        SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object[] args = retryRequest.getArgs();
        JobTriggerDTO jobTriggerDTO = (JobTriggerDTO)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)args[0]), JobTriggerDTO.class);
        Job job = (Job)this.jobMapper.selectById((Serializable)jobTriggerDTO.getJobId());
        Assert.notNull((Object)job, () -> new SnailJobServerException("job can not be null."));
        long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)job.getGroupName())).eq(GroupConfig::getNamespaceId, (Object)job.getNamespaceId())).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        if (count <= 0L) {
            SnailJobLog.LOCAL.warn("Group [{}] is closed, manual execution is not supported.", new Object[]{job.getGroupName()});
            return new SnailJobRpcResult((Object)false, retryRequest.getReqId());
        }
        JobTaskPrepareDTO jobTaskPrepare = JobTaskConverter.INSTANCE.toJobTaskPrepare(job);
        jobTaskPrepare.setNextTriggerAt(DateUtils.toNowMilli());
        jobTaskPrepare.setTaskExecutorScene(JobTaskExecutorSceneEnum.MANUAL_JOB.getType());
        if (StrUtil.isNotBlank((CharSequence)jobTriggerDTO.getTmpArgsStr())) {
            jobTaskPrepare.setTmpArgsStr(jobTriggerDTO.getTmpArgsStr());
        }
        this.terminalJobPrepareHandler.handle(jobTaskPrepare);
        return new SnailJobRpcResult((Object)true, retryRequest.getReqId());
    }

    @Generated
    public OpenApiTriggerJobRequestHandler(JobMapper jobMapper, AccessTemplate accessTemplate, JobPrepareHandler terminalJobPrepareHandler) {
        this.jobMapper = jobMapper;
        this.accessTemplate = accessTemplate;
        this.terminalJobPrepareHandler = terminalJobPrepareHandler;
    }
}

