/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.stop;

import com.aizuda.snailjob.client.model.StopJobDTO;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.dto.InstanceKey;
import com.aizuda.snailjob.server.common.dto.InstanceLiveInfo;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.server.job.task.client.JobRpcClient;
import com.aizuda.snailjob.server.job.task.dto.RealStopTaskInstanceDTO;
import java.util.Objects;
import lombok.Generated;
import org.apache.pekko.actor.AbstractActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="JobRealStopTaskInstanceActor")
@Scope(value="prototype")
public class RealStopTaskActor
extends AbstractActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RealStopTaskActor.class);
    private final InstanceManager instanceManager;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(RealStopTaskInstanceDTO.class, realStopTaskInstanceDTO -> {
            try {
                this.doStop((RealStopTaskInstanceDTO)realStopTaskInstanceDTO);
            }
            catch (Exception e) {
                log.error("Stopping task execution failed. [{}]", (Object)JsonUtil.toJsonString((Object)realStopTaskInstanceDTO), (Object)e);
            }
        }).build();
    }

    private void doStop(RealStopTaskInstanceDTO realStopTaskInstanceDTO) {
        InstanceLiveInfo instanceLiveInfo = this.instanceManager.getInstanceALiveInfoSet(InstanceKey.builder().namespaceId(realStopTaskInstanceDTO.getNamespaceId()).groupName(realStopTaskInstanceDTO.getGroupName()).hostId(realStopTaskInstanceDTO.getClientId()).build());
        if (Objects.nonNull(instanceLiveInfo)) {
            this.requestClient(realStopTaskInstanceDTO, instanceLiveInfo);
        }
    }

    private Result<Boolean> requestClient(RealStopTaskInstanceDTO realStopTaskInstanceDTO, InstanceLiveInfo instanceLiveInfo) {
        JobRpcClient rpcClient = (JobRpcClient)RequestBuilder.newBuilder().nodeInfo(instanceLiveInfo).failRetry(Boolean.TRUE.booleanValue()).retryTimes(3).retryInterval(1).client(JobRpcClient.class).build();
        StopJobDTO stopJobDTO = new StopJobDTO();
        stopJobDTO.setTaskBatchId(realStopTaskInstanceDTO.getTaskBatchId());
        stopJobDTO.setJobId(realStopTaskInstanceDTO.getJobId());
        stopJobDTO.setGroupName(realStopTaskInstanceDTO.getGroupName());
        return rpcClient.stop(stopJobDTO);
    }

    @Generated
    public RealStopTaskActor(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }
}

