/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.request;

import cn.hutool.core.net.url.UrlQuery;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.convert.JobConverter;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.CronUtils;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.common.util.HttpHeaderUtil;
import com.aizuda.snailjob.server.common.util.TriggerIntervalUtils;
import com.aizuda.snailjob.server.common.vo.JobRequestVO;
import com.aizuda.snailjob.server.job.task.support.cache.ResidentTaskCache;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class OpenApiUpdateJobRequestHandler
extends PostHttpRequestHandler {
    private final JobMapper jobMapper;

    public boolean supports(String path) {
        return "/api/job/update".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    public SnailJobRpcResult doHandler(String content, UrlQuery query, HttpHeaders headers) {
        SnailJobLog.LOCAL.debug("Update job content:[{}]", new Object[]{content});
        SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object[] args = retryRequest.getArgs();
        String namespace = HttpHeaderUtil.getNamespace((HttpHeaders)headers);
        JobRequestVO jobRequestVO = (JobRequestVO)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)args[0]), JobRequestVO.class);
        if (Objects.isNull(jobRequestVO.getId())) {
            SnailJobLog.LOCAL.warn("ID cannot be empty, update failed", new Object[0]);
            return new SnailJobRpcResult((Object)false, retryRequest.getReqId());
        }
        Job job = (Job)this.jobMapper.selectById((Serializable)jobRequestVO.getId());
        if (Objects.isNull(job)) {
            SnailJobLog.LOCAL.warn("Job is null, update failed", new Object[0]);
            return new SnailJobRpcResult((Object)false, retryRequest.getReqId());
        }
        Job updateJob = JobConverter.INSTANCE.convert(jobRequestVO);
        updateJob.setResident(this.isResident(jobRequestVO));
        updateJob.setNamespaceId(namespace);
        this.checkTriggerInterval(jobRequestVO);
        if (Objects.equals(jobRequestVO.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            updateJob.setNextTriggerAt(Long.valueOf(0L));
        } else if (Objects.equals(job.getResident(), StatusEnum.NO.getStatus()) && Objects.equals(updateJob.getResident(), StatusEnum.NO.getStatus())) {
            updateJob.setNextTriggerAt(OpenApiUpdateJobRequestHandler.calculateNextTriggerAt(updateJob, DateUtils.toNowMilli()));
        } else if (Objects.equals(job.getResident(), StatusEnum.YES.getStatus()) && Objects.equals(updateJob.getResident(), StatusEnum.NO.getStatus())) {
            long time = Optional.ofNullable(ResidentTaskCache.get(jobRequestVO.getId())).orElse(DateUtils.toNowMilli());
            updateJob.setNextTriggerAt(OpenApiUpdateJobRequestHandler.calculateNextTriggerAt(updateJob, time));
        } else if (Objects.equals(job.getResident(), StatusEnum.NO.getStatus()) && Objects.equals(updateJob.getResident(), StatusEnum.YES.getStatus())) {
            updateJob.setNextTriggerAt(Long.valueOf(DateUtils.toNowMilli()));
        }
        updateJob.setGroupName(null);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(Job::getId, (Object)jobRequestVO.getId());
        updateWrapper.set(Job::getOwnerId, (Object)jobRequestVO.getOwnerId());
        boolean update = 1 == this.jobMapper.update((Object)updateJob, (Wrapper)updateWrapper);
        return new SnailJobRpcResult((Object)update, retryRequest.getReqId());
    }

    private void checkTriggerInterval(JobRequestVO jobRequestVO) {
        TriggerIntervalUtils.checkTriggerInterval((String)jobRequestVO.getTriggerInterval(), (Integer)jobRequestVO.getTriggerType());
    }

    private Integer isResident(JobRequestVO jobRequestVO) {
        if (Objects.equals(jobRequestVO.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            return StatusEnum.NO.getStatus();
        }
        if (Objects.equals(jobRequestVO.getTriggerType(), WaitStrategies.WaitStrategyEnum.FIXED.getType())) {
            if (Integer.parseInt(jobRequestVO.getTriggerInterval()) < 10) {
                return StatusEnum.YES.getStatus();
            }
        } else if (Objects.equals(jobRequestVO.getTriggerType(), WaitStrategies.WaitStrategyEnum.CRON.getType())) {
            if (CronUtils.getExecuteInterval((String)jobRequestVO.getTriggerInterval()) < 10000L) {
                return StatusEnum.YES.getStatus();
            }
        } else {
            if (Objects.equals(jobRequestVO.getTriggerType(), WaitStrategies.WaitStrategyEnum.POINT_IN_TIME.getType())) {
                return StatusEnum.NO.getStatus();
            }
            throw new SnailJobServerException("Unknown trigger type");
        }
        return StatusEnum.NO.getStatus();
    }

    private static Long calculateNextTriggerAt(Job job, Long time) {
        if (Objects.equals(job.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            return 0L;
        }
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)job.getTriggerType());
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setTriggerInterval(job.getTriggerInterval());
        waitStrategyContext.setNextTriggerAt(time.longValue());
        return waitStrategy.computeTriggerTime(waitStrategyContext);
    }

    @Generated
    public OpenApiUpdateJobRequestHandler(JobMapper jobMapper) {
        this.jobMapper = jobMapper;
    }
}

