/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.request;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.url.UrlQuery;
import com.aizuda.snailjob.client.model.request.MapTaskRequest;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.enums.MapReduceStageEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import com.aizuda.snailjob.server.common.util.HttpHeaderUtil;
import com.aizuda.snailjob.server.job.task.support.JobExecutor;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.executor.job.JobExecutorContext;
import com.aizuda.snailjob.server.job.task.support.executor.job.JobExecutorFactory;
import com.aizuda.snailjob.server.job.task.support.generator.task.JobTaskGenerateContext;
import com.aizuda.snailjob.server.job.task.support.generator.task.JobTaskGenerator;
import com.aizuda.snailjob.server.job.task.support.generator.task.JobTaskGeneratorFactory;
import com.aizuda.snailjob.server.job.task.support.handler.JobTaskBatchHandler;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class MapTaskPostHttpRequestHandler
extends PostHttpRequestHandler {
    private final WorkflowTaskBatchMapper workflowTaskBatchMapper;
    private final JobMapper jobMapper;
    private final JobTaskBatchHandler jobTaskBatchHandler;

    public boolean supports(String path) {
        return "/batch/report/job/map/task/v1".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    public SnailJobRpcResult doHandler(String content, UrlQuery query, HttpHeaders headers) {
        SnailJobLog.LOCAL.info("map task Request. content:[{}]", new Object[]{content});
        String groupName = HttpHeaderUtil.getGroupName((HttpHeaders)headers);
        String namespace = HttpHeaderUtil.getNamespace((HttpHeaders)headers);
        SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        try {
            return this.doHandlerMapTask(retryRequest, namespace, groupName);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("map task Request error. content:[{}]", new Object[]{content, e});
            return new SnailJobRpcResult(StatusEnum.NO.getStatus().intValue(), e.getMessage(), (Object)Boolean.FALSE, retryRequest.getReqId());
        }
    }

    private SnailJobRpcResult doHandlerMapTask(SnailJobRequest retryRequest, String namespace, String groupName) {
        Object[] args = retryRequest.getArgs();
        MapTaskRequest mapTaskRequest = (MapTaskRequest)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)args[0]), MapTaskRequest.class);
        Job job = (Job)this.jobMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Job::getId, (Object)mapTaskRequest.getJobId())).eq(Job::getGroupName, (Object)groupName)).eq(Job::getNamespaceId, (Object)namespace));
        if (Objects.isNull(job)) {
            return new SnailJobRpcResult(StatusEnum.NO.getStatus().intValue(), "Job config not existed", (Object)Boolean.FALSE, retryRequest.getReqId());
        }
        String argStr = this.jobTaskBatchHandler.getArgStr(mapTaskRequest.getTaskBatchId(), job);
        JobTaskGenerator taskInstance = JobTaskGeneratorFactory.getTaskInstance(job.getTaskType());
        JobTaskGenerateContext context = JobTaskConverter.INSTANCE.toJobTaskInstanceGenerateContext(mapTaskRequest);
        context.setGroupName(groupName);
        context.setArgsStr(argStr);
        context.setNamespaceId(namespace);
        context.setMrStage(MapReduceStageEnum.MAP.getStage());
        context.setMapSubTask(mapTaskRequest.getSubTask());
        context.setWfContext(mapTaskRequest.getWfContext());
        List<JobTask> taskList = taskInstance.generate(context);
        if (CollUtil.isEmpty(taskList)) {
            return new SnailJobRpcResult(StatusEnum.NO.getStatus().intValue(), "Job task is empty", (Object)Boolean.FALSE, retryRequest.getReqId());
        }
        String newWfContext = null;
        if (Objects.nonNull(mapTaskRequest.getWorkflowTaskBatchId()) && mapTaskRequest.getWorkflowTaskBatchId() > 0L) {
            WorkflowTaskBatch workflowTaskBatch = (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectOne((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{WorkflowTaskBatch::getWfContext, WorkflowTaskBatch::getId}).eq(WorkflowTaskBatch::getId, (Object)mapTaskRequest.getWorkflowTaskBatchId()));
            Assert.notNull((Object)workflowTaskBatch, () -> new SnailJobServerException("workflowTaskBatch is null. id:[{}]", new Object[]{mapTaskRequest.getWorkflowTaskBatchId()}));
            newWfContext = workflowTaskBatch.getWfContext();
        }
        JobExecutor jobExecutor = JobExecutorFactory.getJobExecutor(JobTaskTypeEnum.MAP_REDUCE.getType());
        jobExecutor.execute(MapTaskPostHttpRequestHandler.buildJobExecutorContext(mapTaskRequest, job, taskList, newWfContext));
        return new SnailJobRpcResult(StatusEnum.YES.getStatus().intValue(), "Report Map Task Processed Successfully", (Object)Boolean.TRUE, retryRequest.getReqId());
    }

    private static JobExecutorContext buildJobExecutorContext(MapTaskRequest mapTaskRequest, Job job, List<JobTask> taskList, String newWfContext) {
        JobExecutorContext context = JobTaskConverter.INSTANCE.toJobExecutorContext(job);
        context.setTaskList(taskList);
        context.setTaskBatchId(mapTaskRequest.getTaskBatchId());
        context.setWorkflowTaskBatchId(mapTaskRequest.getWorkflowTaskBatchId());
        context.setWorkflowNodeId(mapTaskRequest.getWorkflowNodeId());
        context.setWfContext(newWfContext);
        return context;
    }

    @Generated
    public MapTaskPostHttpRequestHandler(WorkflowTaskBatchMapper workflowTaskBatchMapper, JobMapper jobMapper, JobTaskBatchHandler jobTaskBatchHandler) {
        this.workflowTaskBatchMapper = workflowTaskBatchMapper;
        this.jobMapper = jobMapper;
        this.jobTaskBatchHandler = jobTaskBatchHandler;
    }
}

