/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.request;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.net.url.UrlQuery;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import com.aizuda.snailjob.server.common.util.HttpHeaderUtil;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobSummaryMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobSummary;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class OpenApiDeleteJobRequestHandler
extends PostHttpRequestHandler {
    private final JobMapper jobMapper;
    private final JobSummaryMapper jobSummaryMapper;

    public boolean supports(String path) {
        return "/api/job/deleteJob".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    public SnailJobRpcResult doHandler(String content, UrlQuery query, HttpHeaders headers) {
        SnailJobLog.LOCAL.debug("Delete job content:[{}]", new Object[]{content});
        SnailJobRequest request = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object[] args = request.getArgs();
        Set ids = (Set)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)args[0]), Set.class);
        String namespaceId = HttpHeaderUtil.getNamespace((HttpHeaders)headers);
        Assert.isTrue((ids.size() == this.jobMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Job::getNamespaceId, (Object)namespaceId)).eq(Job::getJobStatus, (Object)StatusEnum.NO.getStatus())).in(Job::getId, (Collection)ids)) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to delete scheduled task, please check if the task status is closed"));
        List jobSummaries = this.jobSummaryMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{JobSummary::getId}).in(JobSummary::getBusinessId, (Collection)ids)).eq(JobSummary::getNamespaceId, (Object)namespaceId)).eq(JobSummary::getSystemTaskType, (Object)SyetemTaskTypeEnum.JOB.getType()));
        if (CollUtil.isNotEmpty((Collection)jobSummaries)) {
            this.jobSummaryMapper.deleteByIds((Collection)StreamUtils.toSet((Collection)jobSummaries, JobSummary::getId));
        }
        return new SnailJobRpcResult((Object)true, request.getReqId());
    }

    @Generated
    public OpenApiDeleteJobRequestHandler(JobMapper jobMapper, JobSummaryMapper jobSummaryMapper) {
        this.jobMapper = jobMapper;
        this.jobSummaryMapper = jobSummaryMapper;
    }
}

