/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.timer;

import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.TimerTask;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.job.task.dto.RealJobExecutorDTO;
import com.aizuda.snailjob.server.job.task.support.timer.JobTimerWheel;
import io.netty.util.Timeout;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import lombok.Generated;
import org.apache.pekko.actor.ActorRef;

public class RetryJobTimerTask
implements TimerTask<String> {
    public static final String IDEMPOTENT_KEY_PREFIX = "retry_job_{0}";
    private RealJobExecutorDTO jobExecutorDTO;

    public void run(Timeout timeout) throws Exception {
        SnailJobLog.LOCAL.debug("\u5f00\u59cb\u6267\u884c\u91cd\u8bd5\u4efb\u52a1\u8c03\u5ea6. \u5f53\u524d\u65f6\u95f4:[{}] taskId:[{}]", new Object[]{LocalDateTime.now(), this.jobExecutorDTO.getTaskBatchId()});
        JobTimerWheel.clearCache(this.idempotentKey());
        try {
            ActorRef actorRef = ActorGenerator.jobRealTaskExecutorActor();
            actorRef.tell((Object)this.jobExecutorDTO, actorRef);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("\u91cd\u8bd5\u4efb\u52a1\u8c03\u5ea6\u6267\u884c\u5931\u8d25", new Object[]{e});
        }
    }

    public String idempotentKey() {
        return MessageFormat.format(IDEMPOTENT_KEY_PREFIX, this.jobExecutorDTO.getTaskId());
    }

    @Generated
    public RetryJobTimerTask(RealJobExecutorDTO jobExecutorDTO) {
        this.jobExecutorDTO = jobExecutorDTO;
    }
}

