/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.timer;

import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.TimerTask;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.dto.JobTimerTaskDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.timer.JobTimerWheel;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import io.netty.util.Timeout;
import java.text.MessageFormat;
import lombok.Generated;
import org.apache.pekko.actor.ActorRef;

public class ResidentJobTimerTask
implements TimerTask<String> {
    private static final String IDEMPOTENT_KEY_PREFIX = " resident_job_{0}";
    private JobTimerTaskDTO jobTimerTaskDTO;
    private Job job;

    public void run(Timeout timeout) throws Exception {
        try {
            JobTimerWheel.clearCache(this.idempotentKey());
            JobTaskPrepareDTO jobTaskPrepare = JobTaskConverter.INSTANCE.toJobTaskPrepare(this.job);
            jobTaskPrepare.setTaskExecutorScene(JobTaskExecutorSceneEnum.AUTO_JOB.getType());
            ActorRef actorRef = ActorGenerator.jobTaskPrepareActor();
            actorRef.tell((Object)jobTaskPrepare, actorRef);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("\u4efb\u52a1\u8c03\u5ea6\u6267\u884c\u5931\u8d25", new Object[]{e});
        }
    }

    public String idempotentKey() {
        return MessageFormat.format(IDEMPOTENT_KEY_PREFIX, this.jobTimerTaskDTO.getTaskBatchId());
    }

    @Generated
    public ResidentJobTimerTask(JobTimerTaskDTO jobTimerTaskDTO, Job job) {
        this.jobTimerTaskDTO = jobTimerTaskDTO;
        this.job = job;
    }
}

