/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.schedule;

import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.schedule.AbstractSchedule;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.job.task.dto.JobPartitionTaskDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobLogMessageMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.JobLogMessage;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;

@Component
public class JobClearLogSchedule
extends AbstractSchedule
implements Lifecycle {
    private final SystemProperties systemProperties;
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final JobTaskMapper jobTaskMapper;
    private final JobLogMessageMapper jobLogMessageMapper;
    private final TransactionTemplate transactionTemplate;

    public String lockName() {
        return "jobClearLog";
    }

    public String lockAtMost() {
        return "PT4H";
    }

    public String lockAtLeast() {
        return "PT1M";
    }

    protected void doExecute() {
        try {
            if (this.systemProperties.getLogStorage() <= 1) {
                SnailJobLog.LOCAL.error("job clear log storage error", new Object[]{this.systemProperties.getLogStorage()});
                return;
            }
            LocalDateTime endTime = LocalDateTime.now().minusDays(this.systemProperties.getLogStorage());
            long total = PartitionTaskUtils.process(startId -> this.jobTaskBatchList(startId, endTime), this::processJobLogPartitionTasks, (long)0L);
            SnailJobLog.LOCAL.debug("Job clear success total:[{}]", new Object[]{total});
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("job clear log error", new Object[]{e});
        }
    }

    private List<JobPartitionTaskDTO> jobTaskBatchList(Long startId, LocalDateTime endTime) {
        List jobTaskBatchList = ((Page)this.jobTaskBatchMapper.selectPage((IPage)new Page(0L, 1000L), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().ge(JobTaskBatch::getId, (Object)startId)).le(CreateDt::getCreateDt, (Object)endTime)).orderByAsc(JobTaskBatch::getId))).getRecords();
        return JobTaskConverter.INSTANCE.toJobTaskBatchPartitionTasks(jobTaskBatchList);
    }

    public void processJobLogPartitionTasks(List<? extends PartitionTask> partitionTasks) {
        List partitionTasksIds = StreamUtils.toList(partitionTasks, PartitionTask::getId);
        if (CollectionUtils.isEmpty((Collection)partitionTasksIds)) {
            return;
        }
        final List idsPartition = Lists.partition((List)partitionTasksIds, (int)500);
        final HashSet jobTaskListIds = new HashSet();
        final HashSet jobLogMessageListIds = new HashSet();
        for (List ids : idsPartition) {
            List jobLogMessageList;
            List jobTaskList = this.jobTaskMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{JobTask::getId}).in(JobTask::getTaskBatchId, (Collection)ids));
            if (!CollectionUtils.isEmpty((Collection)jobTaskList)) {
                Set jobTask = jobTaskList.stream().map(JobTask::getId).collect(Collectors.toSet());
                jobTaskListIds.addAll(jobTask);
            }
            if (CollectionUtils.isEmpty((Collection)(jobLogMessageList = this.jobLogMessageMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{JobLogMessage::getId}).in(JobLogMessage::getTaskBatchId, (Collection)ids))))) continue;
            Set jobLogMessage = jobLogMessageList.stream().map(JobLogMessage::getId).collect(Collectors.toSet());
            jobLogMessageListIds.addAll(jobLogMessage);
        }
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                idsPartition.forEach(arg_0 -> ((JobTaskBatchMapper)JobClearLogSchedule.this.jobTaskBatchMapper).deleteByIds(arg_0));
                if (!CollectionUtils.isEmpty((Collection)jobTaskListIds)) {
                    Lists.partition(jobTaskListIds.stream().toList(), (int)500).forEach(arg_0 -> ((JobTaskMapper)JobClearLogSchedule.this.jobTaskMapper).deleteByIds(arg_0));
                }
                if (!CollectionUtils.isEmpty((Collection)jobLogMessageListIds)) {
                    Lists.partition(jobLogMessageListIds.stream().toList(), (int)500).forEach(arg_0 -> ((JobLogMessageMapper)JobClearLogSchedule.this.jobLogMessageMapper).deleteByIds(arg_0));
                }
            }
        });
    }

    public void start() {
        this.taskScheduler.scheduleAtFixedRate(() -> ((JobClearLogSchedule)this).execute(), Duration.parse("PT4H"));
    }

    public void close() {
    }

    @Generated
    public JobClearLogSchedule(SystemProperties systemProperties, JobTaskBatchMapper jobTaskBatchMapper, JobTaskMapper jobTaskMapper, JobLogMessageMapper jobLogMessageMapper, TransactionTemplate transactionTemplate) {
        this.systemProperties = systemProperties;
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.jobTaskMapper = jobTaskMapper;
        this.jobLogMessageMapper = jobLogMessageMapper;
        this.transactionTemplate = transactionTemplate;
    }
}

