/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.log;

import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.dto.LogContentDTO;
import com.aizuda.snailjob.common.log.dto.TaskLogFieldDTO;
import com.aizuda.snailjob.common.log.enums.LogTypeEnum;
import com.aizuda.snailjob.server.common.LogStorage;
import com.aizuda.snailjob.server.common.dto.JobLogMetaDTO;
import com.aizuda.snailjob.server.common.dto.LogMetaDTO;
import com.aizuda.snailjob.server.common.log.LogStorageFactory;
import com.aizuda.snailjob.server.common.pekko.ActorGenerator;
import com.aizuda.snailjob.server.job.task.dto.JobLogDTO;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.pekko.actor.ActorRef;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class JobLogStorage
implements LogStorage,
InitializingBean {
    public LogTypeEnum logType() {
        return LogTypeEnum.JOB;
    }

    public void storage(LogContentDTO logContentDTO, LogMetaDTO logMetaDTO) {
        JobLogMetaDTO jobLogMetaDTO = (JobLogMetaDTO)logMetaDTO;
        JobLogDTO jobLogDTO = new JobLogDTO();
        Map<String, String> messageMap = logContentDTO.getFieldList().stream().filter(logTaskDTO_ -> !Objects.isNull(logTaskDTO_.getValue())).collect(Collectors.toMap(TaskLogFieldDTO::getName, TaskLogFieldDTO::getValue));
        jobLogDTO.setMessage(JsonUtil.toJsonString((Object)Lists.newArrayList((Object[])new Map[]{messageMap})));
        jobLogDTO.setTaskId(jobLogMetaDTO.getTaskId());
        jobLogDTO.setJobId(jobLogMetaDTO.getJobId());
        jobLogDTO.setGroupName(logMetaDTO.getGroupName());
        jobLogDTO.setNamespaceId(logMetaDTO.getNamespaceId());
        jobLogDTO.setTaskBatchId(jobLogMetaDTO.getTaskBatchId());
        jobLogDTO.setRealTime(logContentDTO.getTimeStamp());
        ActorRef actorRef = ActorGenerator.jobLogActor();
        actorRef.tell((Object)jobLogDTO, actorRef);
    }

    public void afterPropertiesSet() throws Exception {
        LogStorageFactory.register((LogTypeEnum)this.logType(), (LogStorage)this);
    }
}

