/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.timer;

import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.JobNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.TimerTask;
import com.aizuda.snailjob.server.job.task.dto.JobTaskFailAlarmEventDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.JobTaskStopHandler;
import com.aizuda.snailjob.server.job.task.support.alarm.event.JobTaskFailAlarmEvent;
import com.aizuda.snailjob.server.job.task.support.stop.JobTaskStopFactory;
import com.aizuda.snailjob.server.job.task.support.stop.TaskStopJobContext;
import com.aizuda.snailjob.server.job.task.support.timer.JobTimerWheel;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import io.netty.util.Timeout;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Objects;
import lombok.Generated;
import org.springframework.context.ApplicationEvent;

public class JobTimeoutCheckTask
implements TimerTask<String> {
    private static final String IDEMPOTENT_KEY_PREFIX = "job_timeout_check_{0}";
    private final Long taskBatchId;
    private final Long jobId;

    public void run(Timeout timeout) throws Exception {
        JobTimerWheel.clearCache(this.idempotentKey());
        JobTaskBatchMapper jobTaskBatchMapper = (JobTaskBatchMapper)SnailSpringContext.getBean(JobTaskBatchMapper.class);
        JobTaskBatch jobTaskBatch = (JobTaskBatch)jobTaskBatchMapper.selectById((Serializable)this.taskBatchId);
        if (Objects.isNull(jobTaskBatch)) {
            SnailJobLog.LOCAL.error("jobTaskBatch:[{}]\u4e0d\u5b58\u5728", new Object[]{this.taskBatchId});
            return;
        }
        if (JobTaskBatchStatusEnum.COMPLETED.contains(jobTaskBatch.getTaskBatchStatus())) {
            return;
        }
        JobMapper jobMapper = (JobMapper)SnailSpringContext.getBean(JobMapper.class);
        Job job = (Job)jobMapper.selectById((Serializable)this.jobId);
        if (Objects.isNull(job)) {
            SnailJobLog.LOCAL.error("job:[{}]\u4e0d\u5b58\u5728", new Object[]{this.jobId});
            return;
        }
        JobTaskStopHandler instanceInterrupt = JobTaskStopFactory.getJobTaskStop(job.getTaskType());
        TaskStopJobContext stopJobContext = JobTaskConverter.INSTANCE.toStopJobContext(job);
        stopJobContext.setJobOperationReason(JobOperationReasonEnum.TASK_EXECUTION_TIMEOUT.getReason());
        stopJobContext.setNeedUpdateTaskStatus(Boolean.TRUE);
        stopJobContext.setForceStop(Boolean.TRUE);
        stopJobContext.setTaskBatchId(this.taskBatchId);
        stopJobContext.setWorkflowNodeId(jobTaskBatch.getWorkflowNodeId());
        stopJobContext.setWorkflowTaskBatchId(jobTaskBatch.getWorkflowTaskBatchId());
        instanceInterrupt.stop(stopJobContext);
        String reason = "\u8d85\u65f6\u4e2d\u65ad.taskBatchId:[" + this.taskBatchId + "]";
        SnailSpringContext.getContext().publishEvent((ApplicationEvent)new JobTaskFailAlarmEvent(JobTaskFailAlarmEventDTO.builder().jobTaskBatchId(this.taskBatchId).reason(reason).notifyScene(JobNotifySceneEnum.JOB_TASK_ERROR.getNotifyScene()).build()));
        SnailJobLog.LOCAL.info(reason, new Object[0]);
    }

    public String idempotentKey() {
        return MessageFormat.format(IDEMPOTENT_KEY_PREFIX, this.taskBatchId);
    }

    @Generated
    public JobTimeoutCheckTask(Long taskBatchId, Long jobId) {
        this.taskBatchId = taskBatchId;
        this.jobId = jobId;
    }
}

