/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.handler;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.enums.MapReduceStageEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.JobArgsHolder;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.dto.DistributeInstance;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.dto.CompleteJobBatchDTO;
import com.aizuda.snailjob.server.job.task.dto.JobTimerTaskDTO;
import com.aizuda.snailjob.server.job.task.dto.MapReduceArgsStrDTO;
import com.aizuda.snailjob.server.job.task.dto.TaskExecuteDTO;
import com.aizuda.snailjob.server.job.task.support.JobExecutorResultHandler;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.cache.ResidentTaskCache;
import com.aizuda.snailjob.server.job.task.support.result.job.JobExecutorResultContext;
import com.aizuda.snailjob.server.job.task.support.timer.JobTimerWheel;
import com.aizuda.snailjob.server.job.task.support.timer.ResidentJobTimerTask;
import com.aizuda.snailjob.template.datasource.persistence.mapper.GroupConfigMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class JobTaskBatchHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobTaskBatchHandler.class);
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final JobTaskMapper jobTaskMapper;
    private final GroupConfigMapper groupConfigMapper;
    private final List<JobExecutorResultHandler> resultHandlerList;

    @Transactional
    public boolean handleResult(CompleteJobBatchDTO completeJobBatchDTO) {
        Long countJobTaskBatch;
        Assert.notNull((Object)completeJobBatchDTO.getTaskType(), () -> new SnailJobServerException("taskType can not be null"));
        Assert.notNull((Object)completeJobBatchDTO.getRetryStatus(), () -> new SnailJobServerException("retryStatus can not be null"));
        if (Boolean.FALSE.equals(completeJobBatchDTO.getRetryStatus()) && (countJobTaskBatch = this.jobTaskBatchMapper.selectCount((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getId, (Object)completeJobBatchDTO.getTaskBatchId())).in(JobTaskBatch::getTaskBatchStatus, (Collection)JobTaskBatchStatusEnum.COMPLETED))) > 0L) {
            return true;
        }
        JobExecutorResultContext context = JobTaskConverter.INSTANCE.toJobExecutorResultContext(completeJobBatchDTO);
        for (JobExecutorResultHandler jobExecutorResultHandler : this.resultHandlerList) {
            if (!completeJobBatchDTO.getTaskType().equals(jobExecutorResultHandler.getTaskInstanceType().getType())) continue;
            jobExecutorResultHandler.handleResult(context);
            break;
        }
        return context.isTaskBatchComplete() || context.isCreateReduceTask();
    }

    public void openResidentTask(Job job, TaskExecuteDTO taskExecuteDTO) {
        if (Objects.isNull(job) || JobTaskExecutorSceneEnum.MANUAL_JOB.getType().equals(taskExecuteDTO.getTaskExecutorScene()) || JobTaskExecutorSceneEnum.AUTO_WORKFLOW.getType().equals(taskExecuteDTO.getTaskExecutorScene()) || JobTaskExecutorSceneEnum.MANUAL_WORKFLOW.getType().equals(taskExecuteDTO.getTaskExecutorScene()) || Objects.equals(StatusEnum.NO.getStatus(), job.getResident()) || !DistributeInstance.INSTANCE.getConsumerBucket().contains(job.getBucketIndex())) {
            return;
        }
        long count = this.groupConfigMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)job.getNamespaceId())).eq(GroupConfig::getGroupName, (Object)job.getGroupName())).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        if (count == 0L) {
            return;
        }
        JobTimerTaskDTO jobTimerTaskDTO = new JobTimerTaskDTO();
        jobTimerTaskDTO.setJobId(taskExecuteDTO.getJobId());
        jobTimerTaskDTO.setTaskBatchId(taskExecuteDTO.getTaskBatchId());
        jobTimerTaskDTO.setTaskExecutorScene(JobTaskExecutorSceneEnum.AUTO_JOB.getType());
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)job.getTriggerType());
        Long preTriggerAt = ResidentTaskCache.get(job.getId());
        if (Objects.isNull(preTriggerAt) || preTriggerAt < job.getNextTriggerAt()) {
            preTriggerAt = job.getNextTriggerAt();
        }
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setTriggerInterval(job.getTriggerInterval());
        waitStrategyContext.setNextTriggerAt(preTriggerAt.longValue());
        Long nextTriggerAt = waitStrategy.computeTriggerTime(waitStrategyContext);
        long milliseconds = nextTriggerAt - preTriggerAt;
        Duration duration = Duration.ofMillis(milliseconds - DateUtils.toNowMilli() % 1000L);
        log.debug("\u5e38\u9a7b\u4efb\u52a1\u76d1\u63a7. [{}] \u4efb\u52a1\u65f6\u95f4\u5dee:[{}] \u53d6\u4f59:[{}]", new Object[]{duration, milliseconds, DateUtils.toNowMilli() % 1000L});
        job.setNextTriggerAt(nextTriggerAt);
        JobTimerWheel.registerWithJob(() -> new ResidentJobTimerTask(jobTimerTaskDTO, job), duration);
        ResidentTaskCache.refresh(job.getId(), nextTriggerAt);
    }

    public String getArgStr(Long taskBatchId, Job job) {
        JobTask rootMapTask = this.jobTaskMapper.selectList((IPage)new PageDTO(1L, 1L), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{JobTask::getId, JobTask::getArgsStr}).eq(JobTask::getTaskBatchId, (Object)taskBatchId)).eq(JobTask::getMrStage, (Object)MapReduceStageEnum.MAP.getStage())).eq(JobTask::getTaskName, (Object)"ROOT_MAP")).orderByAsc(JobTask::getId)).stream().findFirst().orElse(null);
        String argsStr = job.getArgsStr();
        if (Objects.nonNull(rootMapTask) && StrUtil.isNotBlank((CharSequence)rootMapTask.getArgsStr())) {
            JobArgsHolder jobArgsHolder = (JobArgsHolder)JsonUtil.parseObject((String)rootMapTask.getArgsStr(), JobArgsHolder.class);
            if (JobTaskTypeEnum.MAP_REDUCE.getType() == job.getTaskType().intValue()) {
                MapReduceArgsStrDTO mapReduceArgsStrDTO = (MapReduceArgsStrDTO)JsonUtil.parseObject((String)argsStr, MapReduceArgsStrDTO.class);
                mapReduceArgsStrDTO.setArgsStr((String)jobArgsHolder.getJobParams());
                argsStr = JsonUtil.toJsonString((Object)mapReduceArgsStrDTO);
            } else {
                argsStr = (String)jobArgsHolder.getJobParams();
            }
        }
        return argsStr;
    }

    @Generated
    public JobTaskBatchHandler(JobTaskBatchMapper jobTaskBatchMapper, JobTaskMapper jobTaskMapper, GroupConfigMapper groupConfigMapper, List<JobExecutorResultHandler> resultHandlerList) {
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.jobTaskMapper = jobTaskMapper;
        this.groupConfigMapper = groupConfigMapper;
        this.resultHandlerList = resultHandlerList;
    }
}

