/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.callback;

import akka.actor.ActorRef;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.handler.ClientNodeAllocateHandler;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.job.task.dto.JobExecutorResultDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.callback.AbstractClientCallbackHandler;
import com.aizuda.snailjob.server.job.task.support.callback.ClientCallbackContext;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ClusterClientCallbackHandler
extends AbstractClientCallbackHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterClientCallbackHandler.class);
    private final ClientNodeAllocateHandler clientNodeAllocateHandler;

    @Override
    public JobTaskTypeEnum getTaskInstanceType() {
        return JobTaskTypeEnum.CLUSTER;
    }

    @Override
    protected String chooseNewClient(ClientCallbackContext context) {
        RegisterNodeInfo serverNode = this.clientNodeAllocateHandler.getServerNode(context.getJobId().toString(), context.getGroupName(), context.getNamespaceId(), context.getJob().getRouteKey());
        if (Objects.isNull(serverNode)) {
            log.error("\u65e0\u53ef\u6267\u884c\u7684\u5ba2\u6237\u7aef\u4fe1\u606f. jobId:[{}]", (Object)context.getJobId());
            return null;
        }
        return ClientInfoUtils.generate((RegisterNodeInfo)serverNode);
    }

    @Override
    protected void doCallback(ClientCallbackContext context) {
        JobExecutorResultDTO jobExecutorResultDTO = JobTaskConverter.INSTANCE.toJobExecutorResultDTO(context);
        jobExecutorResultDTO.setTaskId(context.getTaskId());
        jobExecutorResultDTO.setMessage(context.getExecuteResult().getMessage());
        jobExecutorResultDTO.setResult(context.getExecuteResult().getResult());
        jobExecutorResultDTO.setTaskType(this.getTaskInstanceType().getType());
        ActorRef actorRef = ActorGenerator.jobTaskExecutorResultActor();
        actorRef.tell((Object)jobExecutorResultDTO, actorRef);
    }

    @Generated
    public ClusterClientCallbackHandler(ClientNodeAllocateHandler clientNodeAllocateHandler) {
        this.clientNodeAllocateHandler = clientNodeAllocateHandler;
    }
}

