/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.handler;

import akka.actor.ActorRef;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.JobNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.dto.WorkflowNodeTaskExecuteDTO;
import com.aizuda.snailjob.server.job.task.dto.WorkflowTaskFailAlarmEventDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.JobTaskStopHandler;
import com.aizuda.snailjob.server.job.task.support.alarm.event.WorkflowTaskFailAlarmEvent;
import com.aizuda.snailjob.server.job.task.support.cache.MutableGraphCache;
import com.aizuda.snailjob.server.job.task.support.handler.DistributedLockHandler;
import com.aizuda.snailjob.server.job.task.support.stop.JobTaskStopFactory;
import com.aizuda.snailjob.server.job.task.support.stop.TaskStopJobContext;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.graph.MutableGraph;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
public class WorkflowBatchHandler {
    private static final String KEY = "update_wf_context_{0}";
    private final DistributedLockHandler distributedLockHandler;
    private final WorkflowTaskBatchMapper workflowTaskBatchMapper;
    private final JobMapper jobMapper;
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final JobTaskMapper jobTaskMapper;

    private static boolean checkLeafCompleted(MutableGraph<Long> graph, Map<Long, List<JobTaskBatch>> currentWorkflowNodeMap, Set<Long> parentIds) {
        boolean isNeedProcess = true;
        for (Long nodeId : parentIds) {
            List<JobTaskBatch> jobTaskBatchList = currentWorkflowNodeMap.get(nodeId);
            if (CollUtil.isEmpty(jobTaskBatchList)) {
                isNeedProcess = isNeedProcess || WorkflowBatchHandler.checkLeafCompleted(graph, currentWorkflowNodeMap, graph.predecessors((Object)nodeId));
                continue;
            }
            for (JobTaskBatch jobTaskBatch : jobTaskBatchList) {
                if (JobOperationReasonEnum.WORKFLOW_SUCCESSOR_SKIP_EXECUTION.contains(jobTaskBatch.getOperationReason())) {
                    isNeedProcess = false;
                    continue;
                }
                isNeedProcess = true;
            }
        }
        return isNeedProcess;
    }

    public boolean complete(Long workflowTaskBatchId) {
        return this.complete(workflowTaskBatchId, null);
    }

    public boolean complete(Long workflowTaskBatchId, WorkflowTaskBatch workflowTaskBatch) {
        workflowTaskBatch = Optional.ofNullable(workflowTaskBatch).orElseGet(() -> (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectById((Serializable)workflowTaskBatchId));
        Assert.notNull((Object)workflowTaskBatch, () -> new SnailJobServerException("\u4efb\u52a1\u4e0d\u5b58\u5728"));
        String flowInfo = workflowTaskBatch.getFlowInfo();
        MutableGraph<Long> graph = MutableGraphCache.getOrDefault(workflowTaskBatchId, flowInfo);
        List jobTaskBatches = this.jobTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)workflowTaskBatch.getId())).in(JobTaskBatch::getWorkflowNodeId, (Collection)graph.nodes()));
        if (CollUtil.isEmpty((Collection)jobTaskBatches)) {
            return false;
        }
        if (jobTaskBatches.stream().anyMatch(jobTaskBatch -> JobTaskBatchStatusEnum.NOT_COMPLETE.contains(jobTaskBatch.getTaskBatchStatus()))) {
            return false;
        }
        Map currentWorkflowNodeMap = StreamUtils.groupByKey((Collection)jobTaskBatches, JobTaskBatch::getWorkflowNodeId);
        int taskStatus = JobTaskBatchStatusEnum.SUCCESS.getStatus();
        int operationReason = JobOperationReasonEnum.NONE.getReason();
        List<Long> leaves = MutableGraphCache.getLeaves(workflowTaskBatchId, flowInfo);
        for (Long leaf : leaves) {
            JobTaskBatch jobTaskBatch2;
            boolean isNeedProcess;
            List jobTaskBatchList = currentWorkflowNodeMap.getOrDefault(leaf, Lists.newArrayList());
            if (CollUtil.isEmpty((Collection)jobTaskBatchList) && (isNeedProcess = WorkflowBatchHandler.checkLeafCompleted(graph, currentWorkflowNodeMap, graph.predecessors((Object)leaf)))) {
                return false;
            }
            boolean isMatchSuccess = jobTaskBatchList.stream().anyMatch(jobTaskBatch -> JobTaskStatusEnum.SUCCESS.getStatus() == jobTaskBatch.getTaskBatchStatus().intValue());
            if (isMatchSuccess) continue;
            Iterator iterator = jobTaskBatchList.iterator();
            while (iterator.hasNext() && (jobTaskBatch2 = (JobTaskBatch)iterator.next()).getTaskBatchStatus().intValue() != JobTaskBatchStatusEnum.SUCCESS.getStatus()) {
                if (!JobTaskBatchStatusEnum.NOT_SUCCESS.contains(jobTaskBatch2.getTaskBatchStatus()) || JobOperationReasonEnum.WORKFLOW_NODE_NO_REQUIRED.getReason() == jobTaskBatch2.getOperationReason().intValue() || JobOperationReasonEnum.WORKFLOW_NODE_CLOSED_SKIP_EXECUTION.getReason() == jobTaskBatch2.getOperationReason().intValue()) continue;
                taskStatus = JobTaskBatchStatusEnum.FAIL.getStatus();
                SnailSpringContext.getContext().publishEvent((ApplicationEvent)new WorkflowTaskFailAlarmEvent(WorkflowTaskFailAlarmEventDTO.builder().workflowTaskBatchId(workflowTaskBatchId).notifyScene(JobNotifySceneEnum.WORKFLOW_TASK_ERROR.getNotifyScene()).reason("\u4efb\u52a1\u6267\u884c\u5931\u8d25 jobTaskBatchId:" + jobTaskBatch2.getId()).build()));
            }
        }
        this.handlerTaskBatch(workflowTaskBatchId, taskStatus, operationReason);
        return true;
    }

    private void handlerTaskBatch(Long workflowTaskBatchId, int taskStatus, int operationReason) {
        WorkflowTaskBatch jobTaskBatch = new WorkflowTaskBatch();
        jobTaskBatch.setId(workflowTaskBatchId);
        jobTaskBatch.setTaskBatchStatus(Integer.valueOf(taskStatus));
        jobTaskBatch.setOperationReason(Integer.valueOf(operationReason));
        this.workflowTaskBatchMapper.updateById((Object)jobTaskBatch);
    }

    public void stop(Long workflowTaskBatchId, Integer operationReason) {
        if (Objects.isNull(operationReason) || operationReason.intValue() == JobOperationReasonEnum.NONE.getReason()) {
            operationReason = JobOperationReasonEnum.JOB_OVERLAY.getReason();
        }
        WorkflowTaskBatch workflowTaskBatch = new WorkflowTaskBatch();
        workflowTaskBatch.setTaskBatchStatus(Integer.valueOf(JobTaskBatchStatusEnum.STOP.getStatus()));
        workflowTaskBatch.setOperationReason(operationReason);
        workflowTaskBatch.setId(workflowTaskBatchId);
        Assert.isTrue((1 == this.workflowTaskBatchMapper.updateById((Object)workflowTaskBatch) ? 1 : 0) != 0, () -> new SnailJobServerException("\u505c\u6b62\u5de5\u4f5c\u6d41\u6279\u6b21\u5931\u8d25. id:[{}]", new Object[]{workflowTaskBatchId}));
        SnailSpringContext.getContext().publishEvent((ApplicationEvent)new WorkflowTaskFailAlarmEvent(WorkflowTaskFailAlarmEventDTO.builder().workflowTaskBatchId(workflowTaskBatchId).notifyScene(JobNotifySceneEnum.WORKFLOW_TASK_ERROR.getNotifyScene()).reason("\u505c\u6b62\u5de5\u4f5c\u6d41\u6279\u6b21\u5931\u8d25").build()));
        List jobTaskBatches = this.jobTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(JobTaskBatch::getTaskBatchStatus, (Collection)JobTaskBatchStatusEnum.NOT_COMPLETE)).eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)workflowTaskBatchId));
        if (CollUtil.isEmpty((Collection)jobTaskBatches)) {
            return;
        }
        List jobs = this.jobMapper.selectBatchIds((Collection)StreamUtils.toSet((Collection)jobTaskBatches, JobTaskBatch::getJobId));
        Map jobMap = StreamUtils.toIdentityMap((Collection)jobs, Job::getId);
        for (JobTaskBatch jobTaskBatch : jobTaskBatches) {
            Job job = (Job)jobMap.get(jobTaskBatch.getJobId());
            if (!Objects.nonNull(job)) continue;
            JobTaskStopHandler instanceInterrupt = JobTaskStopFactory.getJobTaskStop(job.getTaskType());
            TaskStopJobContext stopJobContext = JobTaskConverter.INSTANCE.toStopJobContext(job);
            stopJobContext.setTaskBatchId(jobTaskBatch.getId());
            stopJobContext.setJobOperationReason(JobOperationReasonEnum.JOB_TASK_INTERRUPTED.getReason());
            stopJobContext.setNeedUpdateTaskStatus(Boolean.TRUE);
            stopJobContext.setForceStop(Boolean.TRUE);
            instanceInterrupt.stop(stopJobContext);
        }
    }

    public void recoveryWorkflowExecutor(Long workflowTaskBatchId, WorkflowTaskBatch workflowTaskBatch) throws IOException {
        workflowTaskBatch = Optional.ofNullable(workflowTaskBatch).orElseGet(() -> (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectById((Serializable)workflowTaskBatchId));
        Assert.notNull((Object)workflowTaskBatch, () -> new SnailJobServerException("\u4efb\u52a1\u4e0d\u5b58\u5728"));
        String flowInfo = workflowTaskBatch.getFlowInfo();
        MutableGraph<Long> graph = MutableGraphCache.getOrDefault(workflowTaskBatchId, flowInfo);
        Set successors = graph.successors((Object)SystemConstants.ROOT);
        if (CollUtil.isEmpty((Collection)successors)) {
            return;
        }
        List jobTaskBatches = this.jobTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)workflowTaskBatchId)).in(JobTaskBatch::getWorkflowNodeId, (Collection)graph.nodes())).orderByDesc(JobTaskBatch::getId));
        Map jobTaskBatchMap = StreamUtils.toIdentityMap((Collection)jobTaskBatches, JobTaskBatch::getWorkflowNodeId);
        this.recoveryWorkflowExecutor(SystemConstants.ROOT, workflowTaskBatchId, graph, jobTaskBatchMap);
    }

    private void recoveryWorkflowExecutor(Long parentId, Long workflowTaskBatchId, MutableGraph<Long> graph, Map<Long, JobTaskBatch> jobTaskBatchMap) {
        JobTaskBatch parentJobTaskBatch = jobTaskBatchMap.get(parentId);
        if (Objects.nonNull(parentJobTaskBatch) && JobOperationReasonEnum.WORKFLOW_SUCCESSOR_SKIP_EXECUTION.contains(parentJobTaskBatch.getOperationReason())) {
            return;
        }
        Set successors = graph.successors((Object)parentId);
        if (CollUtil.isEmpty((Collection)successors)) {
            return;
        }
        for (Long successor : successors) {
            JobTaskBatch jobTaskBatch = jobTaskBatchMap.get(successor);
            if (Objects.isNull(jobTaskBatch)) {
                WorkflowNodeTaskExecuteDTO taskExecuteDTO = new WorkflowNodeTaskExecuteDTO();
                taskExecuteDTO.setWorkflowTaskBatchId(workflowTaskBatchId);
                taskExecuteDTO.setTaskExecutorScene(JobTaskExecutorSceneEnum.AUTO_WORKFLOW.getType());
                taskExecuteDTO.setParentId(parentId);
                if (Objects.nonNull(parentJobTaskBatch)) {
                    taskExecuteDTO.setTaskBatchId(parentJobTaskBatch.getId());
                }
                this.openNextNode(taskExecuteDTO);
                break;
            }
            if (JobTaskBatchStatusEnum.NOT_COMPLETE.contains(jobTaskBatch.getTaskBatchStatus())) {
                Job job = (Job)this.jobMapper.selectById((Serializable)jobTaskBatch.getJobId());
                JobTaskPrepareDTO jobTaskPrepare = JobTaskConverter.INSTANCE.toJobTaskPrepare(job);
                jobTaskPrepare.setTaskExecutorScene(JobTaskExecutorSceneEnum.AUTO_WORKFLOW.getType());
                jobTaskPrepare.setNextTriggerAt(DateUtils.toNowMilli() + DateUtils.toNowMilli() % 1000L);
                jobTaskPrepare.setWorkflowTaskBatchId(workflowTaskBatchId);
                jobTaskPrepare.setWorkflowNodeId(successor);
                jobTaskPrepare.setParentWorkflowNodeId(parentId);
                ActorRef actorRef = ActorGenerator.jobTaskPrepareActor();
                actorRef.tell((Object)jobTaskPrepare, actorRef);
                break;
            }
            this.recoveryWorkflowExecutor(successor, workflowTaskBatchId, graph, jobTaskBatchMap);
        }
    }

    public void openNextNode(final WorkflowNodeTaskExecuteDTO taskExecuteDTO) {
        if (Objects.isNull(taskExecuteDTO.getParentId()) || Objects.isNull(taskExecuteDTO.getWorkflowTaskBatchId()) || Long.valueOf(0L).equals(taskExecuteDTO.getWorkflowTaskBatchId())) {
            return;
        }
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCompletion(int status) {
                    WorkflowBatchHandler.this.tellWorkflowTaskExecutor(taskExecuteDTO);
                }
            });
        } else {
            this.tellWorkflowTaskExecutor(taskExecuteDTO);
        }
    }

    private void tellWorkflowTaskExecutor(WorkflowNodeTaskExecuteDTO taskExecuteDTO) {
        try {
            ActorRef actorRef = ActorGenerator.workflowTaskExecutorActor();
            actorRef.tell((Object)taskExecuteDTO, actorRef);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("\u4efb\u52a1\u8c03\u5ea6\u6267\u884c\u5931\u8d25", new Object[]{e});
        }
    }

    public void mergeWorkflowContextAndRetry(WorkflowTaskBatch workflowTaskBatch, final Set<Long> taskBatchIds) {
        block3: {
            if (CollUtil.isEmpty(taskBatchIds)) {
                return;
            }
            Retryer retryer = RetryerBuilder.newBuilder().retryIfResult(result -> result.equals(Boolean.FALSE)).retryIfException(ex -> true).withWaitStrategy(WaitStrategies.randomWait((long)800L, (TimeUnit)TimeUnit.MILLISECONDS, (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)3)).withRetryListener(new RetryListener(){

                public <V> void onRetry(Attempt<V> attempt) {
                    Object result = null;
                    if (attempt.hasResult()) {
                        try {
                            result = attempt.get();
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                    }
                    SnailJobLog.LOCAL.info("\u7b2c\u3010{}\u3011\u6b21\u5c1d\u8bd5\u66f4\u65b0\u4e0a\u4e0b\u6587.taskBatchIds:[{}]  result:[{}] treadName:[{}] ", new Object[]{attempt.getAttemptNumber(), taskBatchIds, result, Thread.currentThread().getName()});
                }
            }).build();
            try {
                retryer.call(() -> this.mergeAllWorkflowContext(workflowTaskBatch, taskBatchIds));
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.warn("update workflow global context error. workflowTaskBatchId:[{}] taskBatchIds:[{}]", new Object[]{workflowTaskBatch.getId(), taskBatchIds, e});
                if (!e.getClass().isAssignableFrom(RetryException.class)) break block3;
                this.distributedLockHandler.lockWithDisposableAndRetry(() -> this.mergeAllWorkflowContext(workflowTaskBatch, taskBatchIds), MessageFormat.format(KEY, workflowTaskBatch.getId()), Duration.ofSeconds(1L), Duration.ofSeconds(1L), 3);
            }
        }
    }

    public boolean mergeAllWorkflowContext(WorkflowTaskBatch workflowTaskBatch, Set<Long> taskBatchIds) {
        if (CollUtil.isEmpty(taskBatchIds)) {
            return true;
        }
        List jobTasks = this.jobTaskMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{JobTask::getWfContext, JobTask::getId}).in(JobTask::getTaskBatchId, taskBatchIds));
        if (CollUtil.isEmpty((Collection)jobTasks)) {
            return true;
        }
        Set maps = jobTasks.stream().map(r -> {
            try {
                if (StrUtil.isNotBlank((CharSequence)r.getWfContext())) {
                    return JsonUtil.parseHashMap((String)r.getWfContext(), Object.class);
                }
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.warn("taskId:[{}] result value is not a JSON object. result:[{}]", new Object[]{r.getId(), r.getResultMessage()});
            }
            return new HashMap();
        }).collect(Collectors.toSet());
        Map mergeMap = StrUtil.isBlank((CharSequence)workflowTaskBatch.getWfContext()) ? Maps.newHashMap() : JsonUtil.parseHashMap((String)workflowTaskBatch.getWfContext());
        for (Map map : maps) {
            WorkflowBatchHandler.mergeMaps(mergeMap, map);
        }
        WorkflowTaskBatch waitUpdateWorkflowTaskBatch = new WorkflowTaskBatch();
        waitUpdateWorkflowTaskBatch.setId(workflowTaskBatch.getId());
        waitUpdateWorkflowTaskBatch.setWfContext(JsonUtil.toJsonString((Object)mergeMap));
        waitUpdateWorkflowTaskBatch.setVersion(Integer.valueOf(1));
        return 1 == this.workflowTaskBatchMapper.update((Object)waitUpdateWorkflowTaskBatch, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WorkflowTaskBatch::getId, (Object)workflowTaskBatch.getId())).eq(WorkflowTaskBatch::getVersion, (Object)workflowTaskBatch.getVersion()));
    }

    public boolean mergeWorkflowContext(Long workflowTaskBatchId, Map<String, Object> waitMergeContext) {
        if (CollUtil.isEmpty(waitMergeContext) || Objects.isNull(workflowTaskBatchId)) {
            return true;
        }
        WorkflowTaskBatch workflowTaskBatch = (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectOne((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{WorkflowTaskBatch::getWfContext, WorkflowTaskBatch::getVersion}).eq(WorkflowTaskBatch::getId, (Object)workflowTaskBatchId));
        if (Objects.isNull(workflowTaskBatch)) {
            return true;
        }
        String wfContext = workflowTaskBatch.getWfContext();
        if (StrUtil.isNotBlank((CharSequence)wfContext)) {
            WorkflowBatchHandler.mergeMaps(waitMergeContext, JsonUtil.parseHashMap((String)wfContext));
        }
        int version = workflowTaskBatch.getVersion();
        workflowTaskBatch.setWfContext(JsonUtil.toJsonString(waitMergeContext));
        workflowTaskBatch.setVersion(null);
        return 1 == this.workflowTaskBatchMapper.update((Object)workflowTaskBatch, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WorkflowTaskBatch::getId, (Object)workflowTaskBatchId)).eq(WorkflowTaskBatch::getVersion, (Object)version));
    }

    public static void mergeMaps(Map<String, Object> mainMap, Map<String, Object> waitMergeMap) {
        for (Map.Entry<String, Object> entry : waitMergeMap.entrySet()) {
            mainMap.merge(entry.getKey(), entry.getValue(), (v1, v2) -> v2);
        }
    }

    @Generated
    public WorkflowBatchHandler(DistributedLockHandler distributedLockHandler, WorkflowTaskBatchMapper workflowTaskBatchMapper, JobMapper jobMapper, JobTaskBatchMapper jobTaskBatchMapper, JobTaskMapper jobTaskMapper) {
        this.distributedLockHandler = distributedLockHandler;
        this.workflowTaskBatchMapper = workflowTaskBatchMapper;
        this.jobMapper = jobMapper;
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.jobTaskMapper = jobTaskMapper;
    }
}

