/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.callback;

import akka.actor.ActorRef;
import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.job.task.dto.JobExecutorResultDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.callback.AbstractClientCallbackHandler;
import com.aizuda.snailjob.server.job.task.support.callback.ClientCallbackContext;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BroadcastClientCallbackHandler
extends AbstractClientCallbackHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BroadcastClientCallbackHandler.class);

    @Override
    public JobTaskTypeEnum getTaskInstanceType() {
        return JobTaskTypeEnum.BROADCAST;
    }

    @Override
    protected void doCallback(ClientCallbackContext context) {
        JobExecutorResultDTO jobExecutorResultDTO = JobTaskConverter.INSTANCE.toJobExecutorResultDTO(context);
        jobExecutorResultDTO.setTaskId(context.getTaskId());
        jobExecutorResultDTO.setMessage(context.getExecuteResult().getMessage());
        jobExecutorResultDTO.setResult(context.getExecuteResult().getResult());
        jobExecutorResultDTO.setTaskType(this.getTaskInstanceType().getType());
        ActorRef actorRef = ActorGenerator.jobTaskExecutorResultActor();
        actorRef.tell((Object)jobExecutorResultDTO, actorRef);
    }

    @Override
    protected String chooseNewClient(ClientCallbackContext context) {
        Set nodes = CacheRegisterTable.getServerNodeSet((String)context.getGroupName(), (String)context.getNamespaceId());
        if (CollUtil.isEmpty((Collection)nodes)) {
            log.error("\u65e0\u53ef\u6267\u884c\u7684\u5ba2\u6237\u7aef\u4fe1\u606f. jobId:[{}]", (Object)context.getJobId());
            return null;
        }
        JobTask jobTask = context.getJobTask();
        String clientInfo = jobTask.getClientInfo();
        String clientId = ClientInfoUtils.clientId((String)clientInfo);
        RegisterNodeInfo serverNode = CacheRegisterTable.getServerNode((String)context.getGroupName(), (String)context.getNamespaceId(), (String)clientId);
        if (Objects.isNull(serverNode)) {
            List jobTasks = this.jobTaskMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(JobTask::getTaskBatchId, (Object)context.getTaskBatchId()));
            Set clientIdList = StreamUtils.toSet((Collection)jobTasks, jobTask1 -> ClientInfoUtils.clientId((String)jobTask1.getClientInfo()));
            Set remoteClientIdSet = StreamUtils.toSet((Collection)nodes, RegisterNodeInfo::getHostId);
            Sets.SetView diff = Sets.difference((Set)remoteClientIdSet, (Set)clientIdList);
            String newClientId = (String)CollUtil.getFirst(diff.stream().iterator());
            RegisterNodeInfo registerNodeInfo = CacheRegisterTable.getServerNode((String)context.getGroupName(), (String)context.getNamespaceId(), (String)newClientId);
            if (Objects.isNull(registerNodeInfo)) {
                return clientInfo;
            }
            return ClientInfoUtils.generate((RegisterNodeInfo)registerNodeInfo);
        }
        return clientInfo;
    }
}

