/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.block.job;

import akka.actor.ActorRef;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.enums.BlockStrategyEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.job.task.dto.TaskExecuteDTO;
import com.aizuda.snailjob.server.job.task.support.JobExecutor;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.block.job.AbstracJobBlockStrategy;
import com.aizuda.snailjob.server.job.task.support.block.job.BlockStrategyContext;
import com.aizuda.snailjob.server.job.task.support.executor.job.JobExecutorContext;
import com.aizuda.snailjob.server.job.task.support.executor.job.JobExecutorFactory;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class RecoveryBlockStrategy
extends AbstracJobBlockStrategy {
    private final JobTaskMapper jobTaskMapper;
    private final JobMapper jobMapper;

    @Override
    protected void doBlock(BlockStrategyContext context) {
        Assert.notNull((Object)context.getJobId(), () -> new SnailJobServerException("job id can not be null"));
        Assert.notNull((Object)context.getTaskBatchId(), () -> new SnailJobServerException("task batch id can not be null"));
        Assert.notNull((Object)context.getTaskType(), () -> new SnailJobServerException("task type can not be null"));
        List jobTasks = this.jobTaskMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(JobTask::getTaskBatchId, (Object)context.getTaskBatchId()));
        if (CollUtil.isEmpty((Collection)jobTasks)) {
            TaskExecuteDTO taskExecuteDTO = new TaskExecuteDTO();
            taskExecuteDTO.setTaskBatchId(context.getTaskBatchId());
            taskExecuteDTO.setJobId(context.getJobId());
            taskExecuteDTO.setTaskExecutorScene(JobTaskExecutorSceneEnum.MANUAL_JOB.getType());
            taskExecuteDTO.setWorkflowTaskBatchId(context.getWorkflowTaskBatchId());
            taskExecuteDTO.setWorkflowNodeId(context.getWorkflowNodeId());
            ActorRef actorRef = ActorGenerator.jobTaskExecutorActor();
            actorRef.tell((Object)taskExecuteDTO, actorRef);
            return;
        }
        Job job = (Job)this.jobMapper.selectById((Serializable)context.getJobId());
        JobExecutor jobExecutor = JobExecutorFactory.getJobExecutor(context.getTaskType());
        jobExecutor.execute(RecoveryBlockStrategy.buildJobExecutorContext(context, job, StreamUtils.filter((Collection)jobTasks, jobTask -> JobTaskStatusEnum.NOT_SUCCESS.contains(jobTask.getTaskStatus()))));
    }

    @Override
    protected BlockStrategyEnum blockStrategyEnum() {
        return BlockStrategyEnum.RECOVERY;
    }

    private static JobExecutorContext buildJobExecutorContext(BlockStrategyContext strategyContext, Job job, List<JobTask> taskList) {
        JobExecutorContext context = JobTaskConverter.INSTANCE.toJobExecutorContext(job);
        context.setTaskList(taskList);
        context.setTaskBatchId(strategyContext.getTaskBatchId());
        context.setWorkflowTaskBatchId(strategyContext.getWorkflowTaskBatchId());
        context.setWorkflowNodeId(strategyContext.getWorkflowNodeId());
        return context;
    }

    @Generated
    public RecoveryBlockStrategy(JobTaskMapper jobTaskMapper, JobMapper jobMapper) {
        this.jobTaskMapper = jobTaskMapper;
        this.jobMapper = jobMapper;
    }
}

