/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.alarm.listener;

import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.enums.JobNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.util.EnvironmentUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.alarm.AbstractWorkflowAlarm;
import com.aizuda.snailjob.server.common.dto.NotifyConfigInfo;
import com.aizuda.snailjob.server.common.dto.WorkflowAlarmInfo;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.dto.WorkflowTaskFailAlarmEventDTO;
import com.aizuda.snailjob.server.job.task.support.WorkflowTaskConverter;
import com.aizuda.snailjob.server.job.task.support.alarm.event.WorkflowTaskFailAlarmEvent;
import com.google.common.collect.Lists;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class WorkflowTaskFailAlarmListener
extends AbstractWorkflowAlarm<WorkflowTaskFailAlarmEvent> {
    private final LinkedBlockingQueue<WorkflowTaskFailAlarmEventDTO> queue = new LinkedBlockingQueue(1000);
    private static final String MESSAGES_FORMATTER = "   <font face=\u5fae\u8f6f\u96c5\u9ed1 color=#ff0000 size=4>{}\u73af\u5883 Workflow\u4efb\u52a1\u6267\u884c\u5931\u8d25</font> \n            > \u7a7a\u95f4ID:{}  \n            > \u7ec4\u540d\u79f0:{}  \n            > \u5de5\u4f5c\u6d41\u540d\u79f0:{}  \n            > \u901a\u77e5\u573a\u666f:{}  \n            > \u5931\u8d25\u539f\u56e0:{}  \n            > \u65f6\u95f4:{};\n";

    protected List<WorkflowAlarmInfo> poll() throws InterruptedException {
        WorkflowTaskFailAlarmEventDTO workflowTaskFailAlarmEventDTO = this.queue.poll(100L, TimeUnit.MILLISECONDS);
        if (Objects.isNull(workflowTaskFailAlarmEventDTO)) {
            return Lists.newArrayList();
        }
        ArrayList lists = Lists.newArrayList((Object[])new WorkflowTaskFailAlarmEventDTO[]{workflowTaskFailAlarmEventDTO});
        this.queue.drainTo(lists, 200);
        return WorkflowTaskConverter.INSTANCE.toWorkflowTaskFailAlarmEventDTO(lists);
    }

    protected AlarmContext buildAlarmContext(WorkflowAlarmInfo alarmDTO, NotifyConfigInfo notifyConfig) {
        return AlarmContext.build().text(MESSAGES_FORMATTER, new Object[]{EnvironmentUtils.getActiveProfile(), alarmDTO.getNamespaceId(), alarmDTO.getGroupName(), alarmDTO.getWorkflowName(), JobOperationReasonEnum.getWorkflowNotifyScene((Integer)alarmDTO.getOperationReason()).getDesc(), alarmDTO.getReason(), DateUtils.toNowFormat((DateTimeFormatter)DateUtils.NORM_DATETIME_PATTERN)}).title("{}\u73af\u5883 Workflow\u4efb\u52a1\u6267\u884c\u5931\u8d25", new Object[]{EnvironmentUtils.getActiveProfile()});
    }

    protected void startLog() {
        SnailJobLog.LOCAL.info("WorkflowTaskFailAlarmListener started", new Object[0]);
    }

    protected int getNotifyScene() {
        return JobNotifySceneEnum.WORKFLOW_TASK_ERROR.getNotifyScene();
    }

    protected List<SyetemTaskTypeEnum> getSystemTaskType() {
        return Lists.newArrayList((Object[])new SyetemTaskTypeEnum[]{SyetemTaskTypeEnum.WORKFLOW});
    }

    @TransactionalEventListener(fallbackExecution=true, phase=TransactionPhase.AFTER_COMPLETION)
    public void doOnApplicationEvent(WorkflowTaskFailAlarmEvent event) {
        if (!this.queue.offer(event.getWorkflowTaskFailAlarmEventDTO())) {
            SnailJobLog.LOCAL.warn("Workflow\u4efb\u52a1\u6267\u884c\u5931\u8d25\u544a\u8b66\u961f\u5217\u5df2\u6ee1", new Object[0]);
        }
    }

    @Generated
    public WorkflowTaskFailAlarmListener() {
    }
}

