/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.handler;

import cn.hutool.core.net.url.UrlQuery;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.NettyResult;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.handler.PostHttpRequestHandler;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.support.JobPrepareHandler;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class OpenApiTriggerJobRequestHandler
extends PostHttpRequestHandler {
    private final JobMapper jobMapper;
    private final AccessTemplate accessTemplate;
    private final JobPrepareHandler terminalJobPrepareHandler;

    public boolean supports(String path) {
        return "/api/job/triggerJob".equals(path);
    }

    public HttpMethod method() {
        return HttpMethod.POST;
    }

    public String doHandler(String content, UrlQuery query, HttpHeaders headers) {
        SnailJobLog.LOCAL.debug("Trigger job content:[{}]", new Object[]{content});
        SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
        Object[] args = retryRequest.getArgs();
        Long jobId = (Long)JsonUtil.parseObject((String)JsonUtil.toJsonString((Object)args[0]), Long.class);
        Job job = (Job)this.jobMapper.selectById((Serializable)jobId);
        if (Objects.isNull(job)) {
            SnailJobLog.LOCAL.warn("job can not be null.", new Object[0]);
            return JsonUtil.toJsonString((Object)new NettyResult((Object)false, retryRequest.getReqId()));
        }
        long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)job.getGroupName())).eq(GroupConfig::getNamespaceId, (Object)job.getNamespaceId())).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        if (count <= 0L) {
            SnailJobLog.LOCAL.warn("\u7ec4:[{}]\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u652f\u6301\u624b\u52a8\u6267\u884c.", new Object[]{job.getGroupName()});
            return JsonUtil.toJsonString((Object)new NettyResult((Object)false, retryRequest.getReqId()));
        }
        JobTaskPrepareDTO jobTaskPrepare = JobTaskConverter.INSTANCE.toJobTaskPrepare(job);
        jobTaskPrepare.setNextTriggerAt(DateUtils.toNowMilli());
        jobTaskPrepare.setTaskExecutorScene(JobTaskExecutorSceneEnum.MANUAL_JOB.getType());
        this.terminalJobPrepareHandler.handle(jobTaskPrepare);
        return JsonUtil.toJsonString((Object)new NettyResult((Object)true, retryRequest.getReqId()));
    }

    @Generated
    public OpenApiTriggerJobRequestHandler(JobMapper jobMapper, AccessTemplate accessTemplate, JobPrepareHandler terminalJobPrepareHandler) {
        this.jobMapper = jobMapper;
        this.accessTemplate = accessTemplate;
        this.terminalJobPrepareHandler = terminalJobPrepareHandler;
    }
}

