/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.executor.workflow;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.enums.WorkflowNodeTypeEnum;
import com.aizuda.snailjob.common.core.expression.ExpressionEngine;
import com.aizuda.snailjob.common.core.expression.ExpressionFactory;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.DecisionConfig;
import com.aizuda.snailjob.server.common.dto.JobLogMetaDTO;
import com.aizuda.snailjob.server.common.enums.ExpressionTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.job.task.support.alarm.event.WorkflowTaskFailAlarmEvent;
import com.aizuda.snailjob.server.job.task.support.executor.workflow.AbstractWorkflowExecutor;
import com.aizuda.snailjob.server.job.task.support.executor.workflow.WorkflowExecutorContext;
import com.aizuda.snailjob.server.job.task.support.expression.ExpressionInvocationHandler;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.lang.reflect.InvocationHandler;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;

@Component
public class DecisionWorkflowExecutor
extends AbstractWorkflowExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecisionWorkflowExecutor.class);
    private final WorkflowTaskBatchMapper workflowTaskBatchMapper;

    @Override
    public WorkflowNodeTypeEnum getWorkflowNodeType() {
        return WorkflowNodeTypeEnum.DECISION;
    }

    @Override
    protected void beforeExecute(WorkflowExecutorContext context) {
    }

    @Override
    public void doExecute(WorkflowExecutorContext context) {
        int taskBatchStatus = JobTaskBatchStatusEnum.SUCCESS.getStatus();
        int operationReason = JobOperationReasonEnum.NONE.getReason();
        int jobTaskStatus = JobTaskStatusEnum.SUCCESS.getStatus();
        String message = "";
        String wfContext = "";
        Boolean result = (Boolean)Optional.ofNullable(context.getEvaluationResult()).orElse(Boolean.FALSE);
        if (result.booleanValue() || JobOperationReasonEnum.WORKFLOW_SUCCESSOR_SKIP_EXECUTION.contains(context.getParentOperationReason())) {
            taskBatchStatus = JobTaskBatchStatusEnum.CANCEL.getStatus();
            jobTaskStatus = JobTaskStatusEnum.CANCEL.getStatus();
            operationReason = JobOperationReasonEnum.WORKFLOW_NODE_NO_REQUIRED.getReason();
        } else {
            DecisionConfig decisionConfig = (DecisionConfig)JsonUtil.parseObject((String)context.getNodeInfo(), DecisionConfig.class);
            if (StatusEnum.NO.getStatus().equals(decisionConfig.getDefaultDecision())) {
                try {
                    WorkflowTaskBatch workflowTaskBatch = (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectOne((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{WorkflowTaskBatch::getWfContext}).eq(WorkflowTaskBatch::getId, (Object)context.getWorkflowTaskBatchId()));
                    if (Objects.isNull(workflowTaskBatch)) {
                        operationReason = JobOperationReasonEnum.WORKFLOW_DECISION_FAILED.getReason();
                    } else {
                        wfContext = workflowTaskBatch.getWfContext();
                        ExpressionEngine realExpressionEngine = ExpressionTypeEnum.valueOf((Integer)decisionConfig.getExpressionType());
                        Assert.notNull((Object)realExpressionEngine, () -> new SnailJobServerException("\u8868\u8fbe\u5f0f\u5f15\u64ce\u4e0d\u5b58\u5728"));
                        ExpressionInvocationHandler invocationHandler = new ExpressionInvocationHandler(realExpressionEngine);
                        ExpressionEngine expressionEngine = ExpressionFactory.getExpressionEngine((InvocationHandler)invocationHandler);
                        result = (Boolean)Optional.ofNullable(expressionEngine.eval(decisionConfig.getNodeExpression(), new Object[]{wfContext})).orElse(Boolean.FALSE);
                        if (!result.booleanValue()) {
                            operationReason = JobOperationReasonEnum.WORKFLOW_DECISION_FAILED.getReason();
                        }
                    }
                }
                catch (Exception e) {
                    log.error("\u6267\u884c\u6761\u4ef6\u8868\u8fbe\u5f0f\u89e3\u6790\u5f02\u5e38. \u8868\u8fbe\u5f0f:[{}]\uff0c\u53c2\u6570: [{}]", new Object[]{decisionConfig.getNodeExpression(), wfContext, e});
                    taskBatchStatus = JobTaskBatchStatusEnum.FAIL.getStatus();
                    operationReason = JobOperationReasonEnum.WORKFLOW_CONDITION_NODE_EXECUTION_ERROR.getReason();
                    jobTaskStatus = JobTaskStatusEnum.FAIL.getStatus();
                    message = e.getMessage();
                    SnailSpringContext.getContext().publishEvent((ApplicationEvent)new WorkflowTaskFailAlarmEvent(context.getWorkflowTaskBatchId()));
                }
            } else {
                result = Boolean.TRUE;
            }
        }
        context.setEvaluationResult(result);
        context.setTaskBatchStatus(taskBatchStatus);
        context.setOperationReason(operationReason);
        context.setJobTaskStatus(jobTaskStatus);
        context.setLogMessage(message);
        context.setWfContext(wfContext);
    }

    @Override
    protected boolean doPreValidate(WorkflowExecutorContext context) {
        return true;
    }

    @Override
    protected void afterExecute(WorkflowExecutorContext context) {
        JobTaskBatch jobTaskBatch = this.generateJobTaskBatch(context);
        JobTask jobTask = this.generateJobTask(context, jobTaskBatch);
        JobLogMetaDTO jobLogMetaDTO = new JobLogMetaDTO();
        jobLogMetaDTO.setNamespaceId(context.getNamespaceId());
        jobLogMetaDTO.setGroupName(context.getGroupName());
        jobLogMetaDTO.setTaskBatchId(jobTaskBatch.getId());
        jobLogMetaDTO.setJobId(SystemConstants.DECISION_JOB_ID);
        jobLogMetaDTO.setTaskId(jobTask.getId());
        if (jobTaskBatch.getTaskBatchStatus().intValue() == JobTaskStatusEnum.SUCCESS.getStatus() || JobOperationReasonEnum.WORKFLOW_NODE_NO_REQUIRED.getReason() == context.getOperationReason().intValue()) {
            SnailJobLog.REMOTE.info("\u8282\u70b9Id:[{}] \u51b3\u7b56\u5b8c\u6210. \u4e0a\u4e0b\u6587:[{}] \u51b3\u7b56\u7ed3\u679c:[{}] <|>{}<|>", new Object[]{context.getWorkflowNodeId(), context.getWfContext(), context.getEvaluationResult(), jobLogMetaDTO});
        } else {
            SnailJobLog.REMOTE.error("\u8282\u70b9Id:[{}] \u51b3\u7b56\u5931\u8d25. \u4e0a\u4e0b\u6587:[{}] \u5931\u8d25\u539f\u56e0:[{}] <|>{}<|>", new Object[]{context.getWorkflowNodeId(), context.getWfContext(), context.getLogMessage(), jobLogMetaDTO});
        }
    }

    @Generated
    public DecisionWorkflowExecutor(WorkflowTaskBatchMapper workflowTaskBatchMapper) {
        this.workflowTaskBatchMapper = workflowTaskBatchMapper;
    }
}

