/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.alarm.listener;

import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.enums.JobNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.util.EnvironmentUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.AlarmInfoConverter;
import com.aizuda.snailjob.server.common.alarm.AbstractWorkflowAlarm;
import com.aizuda.snailjob.server.common.dto.NotifyConfigInfo;
import com.aizuda.snailjob.server.common.dto.WorkflowAlarmInfo;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.support.alarm.event.WorkflowTaskFailAlarmEvent;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class WorkflowTaskFailAlarmListener
extends AbstractWorkflowAlarm<WorkflowTaskFailAlarmEvent> {
    private final WorkflowTaskBatchMapper workflowTaskBatchMapper;
    private final LinkedBlockingQueue<Long> queue = new LinkedBlockingQueue(1000);
    private static final String MESSAGES_FORMATTER = "   <font face=\u5fae\u8f6f\u96c5\u9ed1 color=#ff0000 size=4>{}\u73af\u5883 Workflow\u4efb\u52a1\u6267\u884c\u5931\u8d25</font> \n            > \u7a7a\u95f4ID:{}  \n            > \u7ec4\u540d\u79f0:{}  \n            > \u5de5\u4f5c\u6d41\u540d\u79f0:{}  \n            > \u5931\u8d25\u539f\u56e0:{}  \n            > \u65f6\u95f4:{};\n";

    protected List<WorkflowAlarmInfo> poll() throws InterruptedException {
        Long workflowTaskBatchId = this.queue.poll(100L, TimeUnit.MILLISECONDS);
        if (Objects.isNull(workflowTaskBatchId)) {
            return Lists.newArrayList();
        }
        ArrayList workflowTaskBatchIds = Lists.newArrayList((Object[])new Long[]{workflowTaskBatchId});
        this.queue.drainTo(workflowTaskBatchIds, 200);
        List workflowTaskBatches = this.workflowTaskBatchMapper.selectWorkflowBatchList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"batch.id", (Collection)workflowTaskBatchIds)).eq((Object)"batch.deleted", (Object)0));
        return AlarmInfoConverter.INSTANCE.toWorkflowAlarmInfos(workflowTaskBatches);
    }

    protected AlarmContext buildAlarmContext(WorkflowAlarmInfo alarmDTO, NotifyConfigInfo notifyConfig) {
        String desc = JobOperationReasonEnum.getByReason((Integer)alarmDTO.getOperationReason()).getDesc();
        return AlarmContext.build().text(MESSAGES_FORMATTER, new Object[]{EnvironmentUtils.getActiveProfile(), alarmDTO.getNamespaceId(), alarmDTO.getGroupName(), alarmDTO.getWorkflowName(), desc, DateUtils.toNowFormat((DateTimeFormatter)DateUtils.NORM_DATETIME_PATTERN)}).title("{}\u73af\u5883 Workflow\u4efb\u52a1\u6267\u884c\u5931\u8d25", new Object[]{EnvironmentUtils.getActiveProfile()});
    }

    protected void startLog() {
        SnailJobLog.LOCAL.info("WorkflowTaskFailAlarmListener started", new Object[0]);
    }

    protected int getNotifyScene() {
        return JobNotifySceneEnum.WORKFLOW_TASK_ERROR.getNotifyScene();
    }

    protected List<SyetemTaskTypeEnum> getSystemTaskType() {
        return Lists.newArrayList((Object[])new SyetemTaskTypeEnum[]{SyetemTaskTypeEnum.WORKFLOW});
    }

    @TransactionalEventListener(fallbackExecution=true, phase=TransactionPhase.AFTER_COMPLETION)
    public void doOnApplicationEvent(WorkflowTaskFailAlarmEvent event) {
        if (!this.queue.offer(event.getWorkflowTaskBatchId())) {
            SnailJobLog.LOCAL.warn("Workflow\u4efb\u52a1\u6267\u884c\u5931\u8d25\u544a\u8b66\u961f\u5217\u5df2\u6ee1", new Object[0]);
        }
    }

    @Generated
    public WorkflowTaskFailAlarmListener(WorkflowTaskBatchMapper workflowTaskBatchMapper) {
        this.workflowTaskBatchMapper = workflowTaskBatchMapper;
    }
}

