/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.schedule;

import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.schedule.AbstractSchedule;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.job.task.dto.JobPartitionTaskDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobLogMessageMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.JobLogMessage;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;

@Component
public class JobClearLogSchedule
extends AbstractSchedule
implements Lifecycle {
    private static Long lastCleanLogTime = 0L;
    private final SystemProperties systemProperties;
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final JobTaskMapper jobTaskMapper;
    private final JobLogMessageMapper jobLogMessageMapper;
    private final TransactionTemplate transactionTemplate;

    public String lockName() {
        return "jobClearLog";
    }

    public String lockAtMost() {
        return "PT1H";
    }

    public String lockAtLeast() {
        return "PT1M";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute() {
        try {
            if (this.systemProperties.getLogStorage() <= 0 || System.currentTimeMillis() - lastCleanLogTime < 86400000L) {
                return;
            }
            LocalDateTime endTime = LocalDateTime.now().minusDays(this.systemProperties.getLogStorage());
            long total = PartitionTaskUtils.process(startId -> this.jobTaskBatchList(startId, endTime), this::processJobLogPartitionTasks, (long)0L);
            SnailJobLog.LOCAL.debug("Job clear success total:[{}]", new Object[]{total});
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("job clear log error", new Object[]{e});
        }
        finally {
            lastCleanLogTime = System.currentTimeMillis();
        }
    }

    private List<JobPartitionTaskDTO> jobTaskBatchList(Long startId, LocalDateTime endTime) {
        List jobTaskBatchList = ((Page)this.jobTaskBatchMapper.selectPage((IPage)new Page(0L, 1000L), (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().ge(JobTaskBatch::getId, (Object)startId)).le(CreateDt::getCreateDt, (Object)endTime)).orderByAsc(JobTaskBatch::getId))).getRecords();
        return JobTaskConverter.INSTANCE.toJobTaskBatchPartitionTasks(jobTaskBatchList);
    }

    public void processJobLogPartitionTasks(final List<? extends PartitionTask> partitionTasks) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                List ids = StreamUtils.toList((Collection)partitionTasks, PartitionTask::getId);
                if (CollectionUtils.isEmpty((Collection)ids)) {
                    return;
                }
                Lists.partition((List)ids, (int)500).forEach(partIds -> JobClearLogSchedule.this.jobTaskBatchMapper.deleteByIds((Collection)ids));
                List jobTaskList = JobClearLogSchedule.this.jobTaskMapper.selectList((Wrapper)new LambdaQueryWrapper().in(JobTask::getTaskBatchId, (Collection)ids));
                if (CollectionUtils.isEmpty((Collection)jobTaskList)) {
                    return;
                }
                List jobTaskListIds = StreamUtils.toList((Collection)jobTaskList, JobTask::getId);
                Lists.partition((List)jobTaskListIds, (int)500).forEach(partIds -> JobClearLogSchedule.this.jobTaskMapper.deleteByIds((Collection)partIds));
                List jobLogMessageList = JobClearLogSchedule.this.jobLogMessageMapper.selectList((Wrapper)new LambdaQueryWrapper().in(JobLogMessage::getTaskBatchId, (Collection)ids));
                if (CollectionUtils.isEmpty((Collection)jobLogMessageList)) {
                    return;
                }
                List jobLogMessageListIds = StreamUtils.toList((Collection)jobLogMessageList, JobLogMessage::getId);
                Lists.partition((List)jobLogMessageListIds, (int)500).forEach(partIds -> JobClearLogSchedule.this.jobTaskMapper.deleteByIds((Collection)jobLogMessageListIds));
            }
        });
    }

    public void start() {
        this.taskScheduler.scheduleAtFixedRate(() -> ((JobClearLogSchedule)this).execute(), Duration.parse("PT1H"));
    }

    public void close() {
    }

    public JobClearLogSchedule(SystemProperties systemProperties, JobTaskBatchMapper jobTaskBatchMapper, JobTaskMapper jobTaskMapper, JobLogMessageMapper jobLogMessageMapper, TransactionTemplate transactionTemplate) {
        this.systemProperties = systemProperties;
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.jobTaskMapper = jobTaskMapper;
        this.jobLogMessageMapper = jobLogMessageMapper;
        this.transactionTemplate = transactionTemplate;
    }
}

