/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.generator.task;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.JobArgsTypeEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.JobArgsHolder;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.generator.task.AbstractJobTaskGenerator;
import com.aizuda.snailjob.server.job.task.support.generator.task.JobTaskGenerateContext;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class ShardingTaskGenerator
extends AbstractJobTaskGenerator {
    private static final String TASK_NAME = "SHARDING_TASK";
    private final JobTaskMapper jobTaskMapper;

    @Override
    public JobTaskTypeEnum getTaskInstanceType() {
        return JobTaskTypeEnum.SHARDING;
    }

    @Override
    public List<JobTask> doGenerate(JobTaskGenerateContext context) {
        List argsStrs;
        Set serverNodes = CacheRegisterTable.getServerNodeSet((String)context.getGroupName(), (String)context.getNamespaceId());
        if (CollUtil.isEmpty((Collection)serverNodes)) {
            SnailJobLog.LOCAL.error("\u65e0\u53ef\u6267\u884c\u7684\u5ba2\u6237\u7aef\u4fe1\u606f. jobId:[{}]", new Object[]{context.getJobId()});
            return Lists.newArrayList();
        }
        String argsStr = context.getArgsStr();
        if (StrUtil.isBlank((CharSequence)argsStr)) {
            SnailJobLog.LOCAL.error("\u5207\u7247\u53c2\u6570\u4e3a\u7a7a. jobId:[{}]", new Object[]{context.getJobId()});
            return Lists.newArrayList();
        }
        try {
            argsStrs = JsonUtil.parseList((String)argsStr, String.class);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("\u5207\u7247\u53c2\u6570\u89e3\u6790\u5931\u8d25. jobId:[{}]", new Object[]{context.getJobId(), e});
            return Lists.newArrayList();
        }
        ArrayList nodeInfoList = new ArrayList(serverNodes);
        ArrayList<JobTask> jobTasks = new ArrayList<JobTask>(argsStrs.size());
        for (int index = 0; index < argsStrs.size(); ++index) {
            RegisterNodeInfo registerNodeInfo = (RegisterNodeInfo)nodeInfoList.get(index % serverNodes.size());
            JobTask jobTask = JobTaskConverter.INSTANCE.toJobTaskInstance(context);
            jobTask.setClientInfo(ClientInfoUtils.generate((RegisterNodeInfo)registerNodeInfo));
            JobArgsHolder jobArgsHolder = new JobArgsHolder();
            jobArgsHolder.setJobParams(argsStrs.get(index));
            jobTask.setArgsStr(JsonUtil.toJsonString((Object)jobArgsHolder));
            jobTask.setArgsType(JobArgsTypeEnum.JSON.getArgsType());
            jobTask.setTaskStatus(Integer.valueOf(JobTaskStatusEnum.RUNNING.getStatus()));
            jobTask.setResultMessage(Optional.ofNullable(jobTask.getResultMessage()).orElse(""));
            jobTask.setParentId(Long.valueOf(0L));
            jobTask.setRetryCount(Integer.valueOf(0));
            jobTask.setLeaf(StatusEnum.YES.getStatus());
            jobTask.setCreateDt(LocalDateTime.now());
            jobTask.setUpdateDt(LocalDateTime.now());
            jobTask.setTaskName(TASK_NAME);
            jobTasks.add(jobTask);
        }
        this.batchSaveJobTasks(jobTasks);
        return jobTasks;
    }

    public ShardingTaskGenerator(JobTaskMapper jobTaskMapper) {
        this.jobTaskMapper = jobTaskMapper;
    }
}

