/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.dispatch;

import akka.actor.AbstractActor;
import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.dto.TaskLogFieldDTO;
import com.aizuda.snailjob.server.job.task.dto.JobLogDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.model.dto.JobLogTaskDTO;
import com.aizuda.snailjob.server.model.dto.LogTaskDTO;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobLogMessageMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobLogMessage;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="JobLogActor")
@Scope(value="prototype")
public class JobLogActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(JobLogActor.class);
    private final JobLogMessageMapper jobLogMessageMapper;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(List.class, list -> {
            try {
                if (CollUtil.isEmpty((Collection)list)) {
                    return;
                }
                List jobLogTasks = list;
                Map logTaskDTOMap = jobLogTasks.stream().collect(Collectors.groupingBy(JobLogTaskDTO::getTaskId, Collectors.toList()));
                ArrayList<JobLogMessage> jobLogMessageList = new ArrayList<JobLogMessage>();
                for (List logTaskDTOList : logTaskDTOMap.values()) {
                    JobLogMessage jobLogMessage = JobTaskConverter.INSTANCE.toJobLogMessage((LogTaskDTO)logTaskDTOList.get(0));
                    jobLogMessage.setCreateDt(LocalDateTime.now());
                    jobLogMessage.setLogNum(Integer.valueOf(logTaskDTOList.size()));
                    List messageMapList = StreamUtils.toList(logTaskDTOList, taskDTO -> taskDTO.getFieldList().stream().filter(logTaskDTO_ -> !Objects.isNull(logTaskDTO_.getValue())).collect(Collectors.toMap(TaskLogFieldDTO::getName, TaskLogFieldDTO::getValue)));
                    jobLogMessage.setMessage(JsonUtil.toJsonString((Object)messageMapList));
                    jobLogMessageList.add(jobLogMessage);
                }
                this.jobLogMessageMapper.insertBatch(jobLogMessageList);
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u5ba2\u6237\u7aef\u65e5\u5fd7\u5f02\u5e38.", (Throwable)e);
            }
            finally {
                this.getContext().stop(this.getSelf());
            }
        }).match(JobLogDTO.class, jobLogDTO -> {
            try {
                this.saveLogMessage((JobLogDTO)jobLogDTO);
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u65e5\u5fd7\u5f02\u5e38.", (Throwable)e);
            }
            finally {
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    private void saveLogMessage(JobLogDTO jobLogDTO) {
        JobLogMessage jobLogMessage = JobTaskConverter.INSTANCE.toJobLogMessage(jobLogDTO);
        jobLogMessage.setCreateDt(LocalDateTime.now());
        jobLogMessage.setLogNum(Integer.valueOf(1));
        jobLogMessage.setMessage(Optional.ofNullable(jobLogDTO.getMessage()).orElse(""));
        jobLogMessage.setTaskId(Optional.ofNullable(jobLogMessage.getTaskId()).orElse(0L));
        this.jobLogMessageMapper.insert((Object)jobLogMessage);
    }

    public JobLogActor(JobLogMessageMapper jobLogMessageMapper) {
        this.jobLogMessageMapper = jobLogMessageMapper;
    }
}

