/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.timer;

import com.aizuda.snailjob.common.core.context.SpringContext;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.TimerTask;
import com.aizuda.snailjob.server.job.task.support.alarm.event.WorkflowTaskFailAlarmEvent;
import com.aizuda.snailjob.server.job.task.support.handler.WorkflowBatchHandler;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import io.netty.util.Timeout;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Objects;
import org.springframework.context.ApplicationEvent;

public class WorkflowTimeoutCheckTask
implements TimerTask<String> {
    private static final String IDEMPOTENT_KEY_PREFIX = "workflow_timeout_check_{0}";
    private final Long workflowTaskBatchId;

    public void run(Timeout timeout) throws Exception {
        WorkflowTaskBatchMapper workflowTaskBatchMapper = (WorkflowTaskBatchMapper)SpringContext.getBean(WorkflowTaskBatchMapper.class);
        WorkflowTaskBatch workflowTaskBatch = (WorkflowTaskBatch)workflowTaskBatchMapper.selectById((Serializable)this.workflowTaskBatchId);
        if (Objects.isNull(workflowTaskBatch) || JobTaskBatchStatusEnum.COMPLETED.contains(workflowTaskBatch.getTaskBatchStatus())) {
            return;
        }
        WorkflowBatchHandler workflowBatchHandler = (WorkflowBatchHandler)SpringContext.getBean(WorkflowBatchHandler.class);
        workflowBatchHandler.stop(this.workflowTaskBatchId, JobOperationReasonEnum.TASK_EXECUTION_TIMEOUT.getReason());
        SpringContext.getContext().publishEvent((ApplicationEvent)new WorkflowTaskFailAlarmEvent(this.workflowTaskBatchId));
        SnailJobLog.LOCAL.info("\u8d85\u65f6\u4e2d\u65ad.workflowTaskBatchId:[{}]", new Object[]{this.workflowTaskBatchId});
    }

    public String idempotentKey() {
        return MessageFormat.format(IDEMPOTENT_KEY_PREFIX, this.workflowTaskBatchId);
    }

    public WorkflowTimeoutCheckTask(Long workflowTaskBatchId) {
        this.workflowTaskBatchId = workflowTaskBatchId;
    }
}

