/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.handler;

import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.lock.LockBuilder;
import com.aizuda.snailjob.server.common.lock.LockManager;
import com.aizuda.snailjob.server.common.lock.LockProvider;
import com.aizuda.snailjob.server.job.task.support.LockExecutor;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DistributedLockHandler {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockWithDisposableAndRetry(LockExecutor lockExecutor, final String lockName, Duration lockAtMost, Duration sleepTime, Integer maxRetryTimes) {
        block10: {
            block8: {
                LockProvider lockProvider = LockBuilder.newBuilder().withDisposable(lockName).build();
                Retryer retryer = RetryerBuilder.newBuilder().retryIfResult(result -> result.equals(Boolean.FALSE)).retryIfException(ex -> true).withWaitStrategy(WaitStrategies.randomWait((long)sleepTime.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS)).withStopStrategy(StopStrategies.stopAfterAttempt((int)maxRetryTimes)).withRetryListener(new RetryListener(){

                    public <V> void onRetry(Attempt<V> attempt) {
                        Object result = null;
                        if (attempt.hasResult()) {
                            try {
                                result = attempt.get();
                            }
                            catch (ExecutionException executionException) {
                                // empty catch block
                            }
                        }
                        SnailJobLog.LOCAL.debug("\u7b2c\u3010{}\u3011\u6b21\u5c1d\u8bd5\u83b7\u53d6\u9501. lockName:[{}] result:[{}] treadName:[{}]", new Object[]{attempt.getAttemptNumber(), lockName, result, Thread.currentThread().getName()});
                    }
                }).build();
                boolean lock = false;
                try {
                    lock = (Boolean)retryer.call(() -> lockProvider.lock(lockAtMost));
                    if (lock) {
                        lockExecutor.execute();
                    }
                    if (!lock) break block8;
                }
                catch (Exception e) {
                    block9: {
                        try {
                            RetryException re;
                            Attempt lastFailedAttempt;
                            Throwable throwable = e;
                            if (e.getClass().isAssignableFrom(RetryException.class) && (lastFailedAttempt = (re = (RetryException)e).getLastFailedAttempt()).hasException()) {
                                throwable = lastFailedAttempt.getExceptionCause();
                            }
                            SnailJobLog.LOCAL.warn("lock execute error. lockName:[{}]", new Object[]{lockName, throwable});
                            if (!lock) break block9;
                        }
                        catch (Throwable throwable) {
                            if (lock) {
                                lockProvider.unlock();
                                SnailJobLog.LOCAL.debug("[{}] \u9501\u5df2\u91ca\u653e", new Object[]{lockName});
                            } else {
                                LockManager.clear();
                            }
                            throw throwable;
                        }
                        lockProvider.unlock();
                        SnailJobLog.LOCAL.debug("[{}] \u9501\u5df2\u91ca\u653e", new Object[]{lockName});
                    }
                    LockManager.clear();
                }
                lockProvider.unlock();
                SnailJobLog.LOCAL.debug("[{}] \u9501\u5df2\u91ca\u653e", new Object[]{lockName});
                break block10;
            }
            LockManager.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockWithDisposable(LockExecutor lockExecutor, String lockName, Duration lockAtMost) {
        block9: {
            block7: {
                LockProvider lockProvider = LockBuilder.newBuilder().withDisposable(lockName).build();
                boolean lock = false;
                try {
                    lock = lockProvider.lock(lockAtMost);
                    if (lock) {
                        lockExecutor.execute();
                    }
                    if (!lock) break block7;
                }
                catch (Exception e) {
                    block8: {
                        try {
                            SnailJobLog.LOCAL.error("lock execute error. lockName:[{}]", new Object[]{lockName, e});
                            if (!lock) break block8;
                        }
                        catch (Throwable throwable) {
                            if (lock) {
                                lockProvider.unlock();
                                SnailJobLog.LOCAL.debug("[{}] \u9501\u5df2\u91ca\u653e", new Object[]{lockName});
                            } else {
                                LockManager.clear();
                            }
                            throw throwable;
                        }
                        lockProvider.unlock();
                        SnailJobLog.LOCAL.debug("[{}] \u9501\u5df2\u91ca\u653e", new Object[]{lockName});
                    }
                    LockManager.clear();
                }
                lockProvider.unlock();
                SnailJobLog.LOCAL.debug("[{}] \u9501\u5df2\u91ca\u653e", new Object[]{lockName});
                break block9;
            }
            LockManager.clear();
        }
    }
}

