/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.timer;

import akka.actor.ActorRef;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.dto.JobTimerTaskDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.timer.JobTimerWheel;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResidentJobTimerTask
implements TimerTask {
    private static final Logger log = LoggerFactory.getLogger(ResidentJobTimerTask.class);
    private JobTimerTaskDTO jobTimerTaskDTO;
    private Job job;

    public void run(Timeout timeout) throws Exception {
        try {
            JobTimerWheel.clearCache(SyetemTaskTypeEnum.JOB.getType(), this.jobTimerTaskDTO.getTaskBatchId());
            JobTaskPrepareDTO jobTaskPrepare = JobTaskConverter.INSTANCE.toJobTaskPrepare(this.job);
            jobTaskPrepare.setTaskExecutorScene(JobTaskExecutorSceneEnum.AUTO_JOB.getType());
            ActorRef actorRef = ActorGenerator.jobTaskPrepareActor();
            actorRef.tell((Object)jobTaskPrepare, actorRef);
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u8c03\u5ea6\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
    }

    public ResidentJobTimerTask(JobTimerTaskDTO jobTimerTaskDTO, Job job) {
        this.jobTimerTaskDTO = jobTimerTaskDTO;
        this.job = job;
    }
}

