/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.timer;

import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.job.task.support.idempotent.TimerIdempotent;
import io.netty.util.HashedWheelTimer;
import io.netty.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component
public class JobTimerWheel
implements Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(JobTimerWheel.class);
    private static final int TICK_DURATION = 100;
    private static final String THREAD_NAME_PREFIX = "job-task-timer-wheel-";
    private static HashedWheelTimer timer = null;
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(32, 32, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new CustomizableThreadFactory("job-task-timer-wheel-"));
    private static final TimerIdempotent idempotent = new TimerIdempotent();

    public void start() {
        timer = new HashedWheelTimer((ThreadFactory)new CustomizableThreadFactory(THREAD_NAME_PREFIX), 100L, TimeUnit.MILLISECONDS, 512, true, -1L, (Executor)executor);
        timer.start();
    }

    public static void register(Integer taskType, Long uniqueId, TimerTask task, long delay, TimeUnit unit) {
        if (!JobTimerWheel.isExisted(taskType, uniqueId)) {
            log.debug("\u52a0\u5165\u65f6\u95f4\u8f6e. delay:[{}ms] taskType:[{}] uniqueId:[{}]", new Object[]{delay, taskType, uniqueId});
            delay = delay < 0L ? 0L : delay;
            try {
                timer.newTimeout(task, delay, unit);
                idempotent.set(uniqueId, uniqueId);
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("\u52a0\u5165\u65f6\u95f4\u8f6e\u5931\u8d25. uniqueId:[{}]", new Object[]{uniqueId, e});
            }
        }
    }

    public static boolean isExisted(Integer taskType, Long uniqueId) {
        return idempotent.isExist((long)taskType, uniqueId);
    }

    public static void clearCache(Integer taskType, Long uniqueId) {
        idempotent.clear((long)taskType, uniqueId);
    }

    public void close() {
        timer.stop();
    }
}

