/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.timer;

import akka.actor.ActorRef;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.job.task.dto.JobTimerTaskDTO;
import com.aizuda.snailjob.server.job.task.dto.TaskExecuteDTO;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobTimerTask
implements TimerTask {
    private static final Logger log = LoggerFactory.getLogger(JobTimerTask.class);
    private JobTimerTaskDTO jobTimerTaskDTO;

    public void run(Timeout timeout) throws Exception {
        log.debug("\u5f00\u59cb\u6267\u884c\u4efb\u52a1\u8c03\u5ea6. \u5f53\u524d\u65f6\u95f4:[{}] taskId:[{}]", (Object)LocalDateTime.now(), (Object)this.jobTimerTaskDTO.getTaskBatchId());
        try {
            TaskExecuteDTO taskExecuteDTO = new TaskExecuteDTO();
            taskExecuteDTO.setTaskBatchId(this.jobTimerTaskDTO.getTaskBatchId());
            taskExecuteDTO.setJobId(this.jobTimerTaskDTO.getJobId());
            taskExecuteDTO.setTaskExecutorScene(this.jobTimerTaskDTO.getTaskExecutorScene());
            taskExecuteDTO.setWorkflowTaskBatchId(this.jobTimerTaskDTO.getWorkflowTaskBatchId());
            taskExecuteDTO.setWorkflowNodeId(this.jobTimerTaskDTO.getWorkflowNodeId());
            ActorRef actorRef = ActorGenerator.jobTaskExecutorActor();
            actorRef.tell((Object)taskExecuteDTO, actorRef);
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u8c03\u5ea6\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
    }

    public JobTimerTask(JobTimerTaskDTO jobTimerTaskDTO) {
        this.jobTimerTaskDTO = jobTimerTaskDTO;
    }
}

