/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.idempotent;

import com.aizuda.snailjob.server.common.IdempotentStrategy;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;

public class TimerIdempotent
implements IdempotentStrategy<Long, Long> {
    private static final String KEY_FORMAT = "{0}_{1}_{2}";
    private static final Cache<String, Long> cache = CacheBuilder.newBuilder().concurrencyLevel(8).expireAfterWrite(20L, TimeUnit.SECONDS).build();

    public boolean set(Long key, Long value) {
        cache.put((Object)TimerIdempotent.getKey(key, value), (Object)value);
        return Boolean.TRUE;
    }

    public Long get(Long s) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
    }

    public boolean isExist(Long key, Long value) {
        return cache.asMap().containsKey(TimerIdempotent.getKey(key, value));
    }

    public boolean clear(Long key, Long value) {
        cache.invalidate((Object)TimerIdempotent.getKey(key, value));
        return Boolean.TRUE;
    }

    private static String getKey(Long key, Long value) {
        return MessageFormat.format(KEY_FORMAT, key, value);
    }
}

