/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.executor.workflow;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.context.SpringContext;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.enums.WorkflowNodeTypeEnum;
import com.aizuda.snailjob.common.core.expression.ExpressionEngine;
import com.aizuda.snailjob.common.core.expression.ExpressionFactory;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.DecisionConfig;
import com.aizuda.snailjob.server.common.dto.JobLogMetaDTO;
import com.aizuda.snailjob.server.common.enums.ExpressionTypeEnum;
import com.aizuda.snailjob.server.common.enums.LogicalConditionEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.job.task.support.alarm.event.WorkflowTaskFailAlarmEvent;
import com.aizuda.snailjob.server.job.task.support.executor.workflow.AbstractWorkflowExecutor;
import com.aizuda.snailjob.server.job.task.support.executor.workflow.WorkflowExecutorContext;
import com.aizuda.snailjob.server.job.task.support.expression.ExpressionInvocationHandler;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DecisionWorkflowExecutor
extends AbstractWorkflowExecutor {
    private static final Logger log = LoggerFactory.getLogger(DecisionWorkflowExecutor.class);
    private final JobTaskMapper jobTaskMapper;

    @Override
    public WorkflowNodeTypeEnum getWorkflowNodeType() {
        return WorkflowNodeTypeEnum.DECISION;
    }

    @Override
    protected void beforeExecute(WorkflowExecutorContext context) {
    }

    @Override
    public void doExecute(WorkflowExecutorContext context) {
        int taskBatchStatus = JobTaskBatchStatusEnum.SUCCESS.getStatus();
        int operationReason = JobOperationReasonEnum.NONE.getReason();
        int jobTaskStatus = JobTaskStatusEnum.SUCCESS.getStatus();
        String message = "";
        Boolean result = (Boolean)Optional.ofNullable(context.getEvaluationResult()).orElse(Boolean.FALSE);
        if (result.booleanValue()) {
            taskBatchStatus = JobTaskBatchStatusEnum.CANCEL.getStatus();
            jobTaskStatus = JobTaskStatusEnum.CANCEL.getStatus();
            operationReason = JobOperationReasonEnum.WORKFLOW_NODE_NO_REQUIRED.getReason();
        } else {
            DecisionConfig decisionConfig = (DecisionConfig)JsonUtil.parseObject((String)context.getNodeInfo(), DecisionConfig.class);
            if (StatusEnum.NO.getStatus().equals(decisionConfig.getDefaultDecision())) {
                try {
                    ExpressionEngine realExpressionEngine = ExpressionTypeEnum.valueOf((Integer)decisionConfig.getExpressionType());
                    Assert.notNull((Object)realExpressionEngine, () -> new SnailJobServerException("\u8868\u8fbe\u5f0f\u5f15\u64ce\u4e0d\u5b58\u5728"));
                    ExpressionInvocationHandler invocationHandler = new ExpressionInvocationHandler(realExpressionEngine);
                    ExpressionEngine expressionEngine = ExpressionFactory.getExpressionEngine((InvocationHandler)invocationHandler);
                    List jobTasks = this.jobTaskMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{JobTask::getResultMessage}).eq(JobTask::getTaskBatchId, (Object)context.getTaskBatchId()));
                    ArrayList taskResult = Lists.newArrayList();
                    Boolean tempResult = null;
                    if (CollectionUtils.isEmpty((Collection)jobTasks)) {
                        tempResult = (Boolean)Optional.ofNullable(expressionEngine.eval(decisionConfig.getNodeExpression(), new Object[]{""})).orElse(Boolean.FALSE);
                    } else {
                        for (JobTask jobTask : jobTasks) {
                            taskResult.add(jobTask.getResultMessage());
                            boolean execResult = (Boolean)Optional.ofNullable(expressionEngine.eval(decisionConfig.getNodeExpression(), new Object[]{jobTask.getResultMessage()})).orElse(Boolean.FALSE);
                            if (Objects.isNull(tempResult)) {
                                tempResult = execResult;
                            }
                            if (Objects.equals(decisionConfig.getLogicalCondition(), LogicalConditionEnum.AND.getCode())) {
                                tempResult = tempResult != false && execResult;
                            } else if ((tempResult = Boolean.valueOf(tempResult != false || execResult)).booleanValue()) break;
                            log.debug("\u6267\u884c\u6761\u4ef6\u8868\u8fbe\u5f0f\uff1a[{}]\uff0c\u53c2\u6570: [{}] \u7ed3\u679c\uff1a[{}]", new Object[]{decisionConfig.getNodeExpression(), jobTask.getResultMessage(), result});
                        }
                    }
                    context.setTaskResult(JsonUtil.toJsonString((Object)taskResult));
                    result = Optional.ofNullable(tempResult).orElse(Boolean.FALSE);
                    if (!result.booleanValue()) {
                        operationReason = JobOperationReasonEnum.WORKFLOW_DECISION_FAILED.getReason();
                    }
                }
                catch (Exception e) {
                    log.error("\u6267\u884c\u6761\u4ef6\u8868\u8fbe\u5f0f\u89e3\u6790\u5f02\u5e38. \u8868\u8fbe\u5f0f:[{}]\uff0c\u53c2\u6570: [{}]", new Object[]{decisionConfig.getNodeExpression(), context.getTaskResult(), e});
                    taskBatchStatus = JobTaskBatchStatusEnum.FAIL.getStatus();
                    operationReason = JobOperationReasonEnum.WORKFLOW_CONDITION_NODE_EXECUTION_ERROR.getReason();
                    jobTaskStatus = JobTaskStatusEnum.FAIL.getStatus();
                    message = e.getMessage();
                    SpringContext.getContext().publishEvent((ApplicationEvent)new WorkflowTaskFailAlarmEvent(context.getWorkflowTaskBatchId()));
                }
            } else {
                result = Boolean.TRUE;
            }
        }
        if (JobTaskBatchStatusEnum.SUCCESS.getStatus() == taskBatchStatus && result.booleanValue()) {
            this.workflowTaskExecutor(context);
        }
        context.setEvaluationResult(result);
        context.setTaskBatchStatus(taskBatchStatus);
        context.setOperationReason(operationReason);
        context.setJobTaskStatus(jobTaskStatus);
        context.setLogMessage(message);
    }

    @Override
    protected boolean doPreValidate(WorkflowExecutorContext context) {
        return true;
    }

    @Override
    protected void afterExecute(WorkflowExecutorContext context) {
        JobTaskBatch jobTaskBatch = this.generateJobTaskBatch(context);
        JobTask jobTask = this.generateJobTask(context, jobTaskBatch);
        JobLogMetaDTO jobLogMetaDTO = new JobLogMetaDTO();
        jobLogMetaDTO.setNamespaceId(context.getNamespaceId());
        jobLogMetaDTO.setGroupName(context.getGroupName());
        jobLogMetaDTO.setTaskBatchId(jobTaskBatch.getId());
        jobLogMetaDTO.setJobId(SystemConstants.DECISION_JOB_ID);
        jobLogMetaDTO.setTaskId(jobTask.getId());
        if (jobTaskBatch.getTaskBatchStatus().intValue() == JobTaskStatusEnum.SUCCESS.getStatus() || JobOperationReasonEnum.WORKFLOW_NODE_NO_REQUIRED.getReason() == context.getOperationReason().intValue()) {
            SnailJobLog.REMOTE.info("\u8282\u70b9Id:[{}] \u51b3\u7b56\u5b8c\u6210. \u4e0a\u4e0b\u6587:[{}] \u51b3\u7b56\u7ed3\u679c:[{}] <|>{}<|>", new Object[]{context.getWorkflowNodeId(), context.getTaskResult(), context.getEvaluationResult(), jobLogMetaDTO});
        } else {
            SnailJobLog.REMOTE.error("\u8282\u70b9Id:[{}] \u51b3\u7b56\u5931\u8d25. \u4e0a\u4e0b\u6587:[{}] \u5931\u8d25\u539f\u56e0:[{}] <|>{}<|>", new Object[]{context.getWorkflowNodeId(), context.getTaskResult(), context.getLogMessage(), jobLogMetaDTO});
        }
    }

    public DecisionWorkflowExecutor(JobTaskMapper jobTaskMapper) {
        this.jobTaskMapper = jobTaskMapper;
    }
}

