/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.dispatch;

import akka.actor.AbstractActor;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.context.SpringContext;
import com.aizuda.snailjob.common.core.enums.FailStrategyEnum;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.dto.WorkflowNodeTaskExecuteDTO;
import com.aizuda.snailjob.server.job.task.support.WorkflowExecutor;
import com.aizuda.snailjob.server.job.task.support.WorkflowTaskConverter;
import com.aizuda.snailjob.server.job.task.support.alarm.event.WorkflowTaskFailAlarmEvent;
import com.aizuda.snailjob.server.job.task.support.cache.MutableGraphCache;
import com.aizuda.snailjob.server.job.task.support.executor.workflow.WorkflowExecutorContext;
import com.aizuda.snailjob.server.job.task.support.executor.workflow.WorkflowExecutorFactory;
import com.aizuda.snailjob.server.job.task.support.handler.WorkflowBatchHandler;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Sets;
import com.google.common.graph.MutableGraph;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="WorkflowExecutorActor")
@Scope(value="prototype")
public class WorkflowExecutorActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(WorkflowExecutorActor.class);
    private final WorkflowTaskBatchMapper workflowTaskBatchMapper;
    private final WorkflowNodeMapper workflowNodeMapper;
    private final JobMapper jobMapper;
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final WorkflowBatchHandler workflowBatchHandler;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(WorkflowNodeTaskExecuteDTO.class, taskExecute -> {
            log.debug("\u5de5\u4f5c\u6d41\u5f00\u59cb\u6267\u884c. [{}]", (Object)JsonUtil.toJsonString((Object)taskExecute));
            try {
                this.doExecutor((WorkflowNodeTaskExecuteDTO)taskExecute);
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("workflow executor exception. [{}]", new Object[]{taskExecute, e});
                this.handlerTaskBatch((WorkflowNodeTaskExecuteDTO)taskExecute, JobTaskBatchStatusEnum.FAIL.getStatus(), JobOperationReasonEnum.TASK_EXECUTION_ERROR.getReason());
                SpringContext.getContext().publishEvent((ApplicationEvent)new WorkflowTaskFailAlarmEvent(taskExecute.getWorkflowTaskBatchId()));
            }
            finally {
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    private void doExecutor(WorkflowNodeTaskExecuteDTO taskExecute) {
        WorkflowNode workflowNode2;
        WorkflowTaskBatch workflowTaskBatch = (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectById((Serializable)taskExecute.getWorkflowTaskBatchId());
        Assert.notNull((Object)workflowTaskBatch, () -> new SnailJobServerException("\u4efb\u52a1\u4e0d\u5b58\u5728"));
        if (SystemConstants.ROOT.equals(taskExecute.getParentId()) && JobTaskBatchStatusEnum.WAITING.getStatus() == workflowTaskBatch.getTaskBatchStatus().intValue()) {
            this.handlerTaskBatch(taskExecute, JobTaskBatchStatusEnum.RUNNING.getStatus(), JobOperationReasonEnum.NONE.getReason());
        }
        String flowInfo = workflowTaskBatch.getFlowInfo();
        MutableGraph<Long> graph = MutableGraphCache.getOrDefault(workflowTaskBatch.getId(), flowInfo);
        Set successors = graph.successors((Object)taskExecute.getParentId());
        if (CollectionUtils.isEmpty((Collection)successors)) {
            this.workflowBatchHandler.complete(taskExecute.getWorkflowTaskBatchId(), workflowTaskBatch);
            return;
        }
        Set<Long> brotherNode = MutableGraphCache.getBrotherNode(graph, taskExecute.getParentId());
        Sets.SetView union = Sets.union((Set)successors, brotherNode);
        List allJobTaskBatchList = this.jobTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{JobTaskBatch::getWorkflowTaskBatchId, JobTaskBatch::getWorkflowNodeId, JobTaskBatch::getTaskBatchStatus, JobTaskBatch::getOperationReason}).eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)workflowTaskBatch.getId())).in(JobTaskBatch::getWorkflowNodeId, (Collection)Sets.union((Set)union, (Set)Sets.newHashSet((Object[])new Long[]{taskExecute.getParentId()}))));
        List workflowNodes = this.workflowNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(WorkflowNode::getId, (Collection)Sets.union((Set)successors, (Set)Sets.newHashSet((Object[])new Long[]{taskExecute.getParentId()})))).orderByAsc(WorkflowNode::getPriorityLevel));
        Map jobTaskBatchMap = StreamUtils.groupByKey((Collection)allJobTaskBatchList, JobTaskBatch::getWorkflowNodeId);
        Map workflowNodeMap = StreamUtils.toIdentityMap((Collection)workflowNodes, WorkflowNode::getId);
        List parentJobTaskBatchList = (List)jobTaskBatchMap.get(taskExecute.getParentId());
        if (!CollectionUtils.isEmpty((Collection)parentJobTaskBatchList)) {
            if (parentJobTaskBatchList.stream().map(JobTaskBatch::getOperationReason).filter(Objects::nonNull).anyMatch(JobOperationReasonEnum.WORKFLOW_SUCCESSOR_SKIP_EXECUTION::contains)) {
                this.workflowBatchHandler.complete(taskExecute.getWorkflowTaskBatchId(), workflowTaskBatch);
                return;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)parentJobTaskBatchList) && parentJobTaskBatchList.stream().map(JobTaskBatch::getTaskBatchStatus).anyMatch(i -> i.intValue() != JobTaskBatchStatusEnum.SUCCESS.getStatus()) && Objects.equals((workflowNode2 = (WorkflowNode)workflowNodeMap.get(taskExecute.getParentId())).getFailStrategy(), FailStrategyEnum.BLOCK.getCode())) {
            return;
        }
        if (!this.brotherNodeIsComplete(taskExecute, brotherNode, jobTaskBatchMap)) {
            return;
        }
        workflowNodes = workflowNodes.stream().filter(workflowNode -> !workflowNode.getId().equals(taskExecute.getParentId())).collect(Collectors.toList());
        List jobs = this.jobMapper.selectBatchIds((Collection)StreamUtils.toSet(workflowNodes, WorkflowNode::getJobId));
        Map jobMap = StreamUtils.toIdentityMap((Collection)jobs, Job::getId);
        Object evaluationResult = null;
        for (WorkflowNode workflowNode3 : workflowNodes) {
            List jobTaskBatchList = (List)jobTaskBatchMap.get(workflowNode3.getId());
            if (!CollectionUtils.isEmpty((Collection)jobTaskBatchList)) continue;
            WorkflowExecutor workflowExecutor = WorkflowExecutorFactory.getWorkflowExecutor(workflowNode3.getNodeType());
            WorkflowExecutorContext context = WorkflowTaskConverter.INSTANCE.toWorkflowExecutorContext(workflowNode3);
            context.setJob((Job)jobMap.get(workflowNode3.getJobId()));
            context.setWorkflowTaskBatchId(taskExecute.getWorkflowTaskBatchId());
            context.setParentWorkflowNodeId(taskExecute.getParentId());
            context.setEvaluationResult(evaluationResult);
            context.setTaskBatchId(taskExecute.getTaskBatchId());
            context.setTaskExecutorScene(taskExecute.getTaskExecutorScene());
            workflowExecutor.execute(context);
            evaluationResult = context.getEvaluationResult();
        }
    }

    private boolean brotherNodeIsComplete(WorkflowNodeTaskExecuteDTO taskExecute, Set<Long> brotherNode, Map<Long, List<JobTaskBatch>> jobTaskBatchMap) {
        if (SystemConstants.ROOT.equals(taskExecute.getParentId())) {
            return Boolean.TRUE;
        }
        for (Long nodeId : brotherNode) {
            List<JobTaskBatch> jobTaskBatches = jobTaskBatchMap.get(nodeId);
            if (CollectionUtils.isEmpty(jobTaskBatches)) {
                SnailJobLog.LOCAL.debug("\u5b58\u5728\u672a\u5b8c\u6210\u7684\u5144\u5f1f\u8282\u70b9. [{}]", new Object[]{nodeId});
                return Boolean.FALSE;
            }
            boolean isCompleted = jobTaskBatches.stream().anyMatch(jobTaskBatch -> JobTaskBatchStatusEnum.NOT_COMPLETE.contains(jobTaskBatch.getTaskBatchStatus()));
            if (!isCompleted) continue;
            SnailJobLog.LOCAL.debug("\u5b58\u5728\u672a\u5b8c\u6210\u7684\u5144\u5f1f\u8282\u70b9. [{}]", new Object[]{nodeId});
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void handlerTaskBatch(WorkflowNodeTaskExecuteDTO taskExecute, int taskStatus, int operationReason) {
        WorkflowTaskBatch jobTaskBatch = new WorkflowTaskBatch();
        jobTaskBatch.setId(taskExecute.getWorkflowTaskBatchId());
        jobTaskBatch.setExecutionAt(Long.valueOf(DateUtils.toNowMilli()));
        jobTaskBatch.setTaskBatchStatus(Integer.valueOf(taskStatus));
        jobTaskBatch.setOperationReason(Integer.valueOf(operationReason));
        jobTaskBatch.setUpdateDt(LocalDateTime.now());
        Assert.isTrue((1 == this.workflowTaskBatchMapper.updateById((Object)jobTaskBatch) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u4efb\u52a1\u5931\u8d25"));
    }

    public WorkflowExecutorActor(WorkflowTaskBatchMapper workflowTaskBatchMapper, WorkflowNodeMapper workflowNodeMapper, JobMapper jobMapper, JobTaskBatchMapper jobTaskBatchMapper, WorkflowBatchHandler workflowBatchHandler) {
        this.workflowTaskBatchMapper = workflowTaskBatchMapper;
        this.workflowNodeMapper = workflowNodeMapper;
        this.jobMapper = jobMapper;
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.workflowBatchHandler = workflowBatchHandler;
    }
}

