/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.dispatch;

import akka.actor.AbstractActor;
import com.aizuda.snailjob.common.core.context.SpringContext;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.support.JobPrePareHandler;
import com.aizuda.snailjob.server.job.task.support.prepare.job.TerminalJobPrepareHandler;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="JobTaskPrepareActor")
@Scope(value="prototype")
public class JobTaskPrepareActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(JobTaskPrepareActor.class);
    @Autowired
    private JobTaskBatchMapper jobTaskBatchMapper;
    @Autowired
    private List<JobPrePareHandler> prePareHandlers;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(JobTaskPrepareDTO.class, job -> {
            try {
                this.doPrepare((JobTaskPrepareDTO)job);
            }
            catch (Exception e) {
                log.error("\u9884\u5904\u7406\u8282\u70b9\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    private void doPrepare(JobTaskPrepareDTO prepare) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getJobId, (Object)prepare.getJobId())).in(JobTaskBatch::getTaskBatchStatus, (Collection)JobTaskBatchStatusEnum.NOT_COMPLETE);
        JobTaskExecutorSceneEnum jobTaskExecutorSceneEnum = JobTaskExecutorSceneEnum.get((Integer)prepare.getTaskExecutorScene());
        if (SyetemTaskTypeEnum.WORKFLOW.getType().equals(jobTaskExecutorSceneEnum.getSystemTaskType().getType())) {
            queryWrapper.eq(JobTaskBatch::getWorkflowNodeId, (Object)prepare.getWorkflowNodeId());
            queryWrapper.eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)prepare.getWorkflowTaskBatchId());
            queryWrapper.eq(JobTaskBatch::getSystemTaskType, (Object)SyetemTaskTypeEnum.WORKFLOW.getType());
        } else {
            queryWrapper.eq(JobTaskBatch::getSystemTaskType, (Object)SyetemTaskTypeEnum.JOB.getType());
        }
        List notCompleteJobTaskBatchList = this.jobTaskBatchMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)notCompleteJobTaskBatchList)) {
            TerminalJobPrepareHandler terminalJobPrepareHandler = (TerminalJobPrepareHandler)SpringContext.getBeanByType(TerminalJobPrepareHandler.class);
            terminalJobPrepareHandler.handler(prepare);
        } else {
            boolean onlyTimeoutCheck = false;
            for (JobTaskBatch jobTaskBatch : notCompleteJobTaskBatchList) {
                prepare.setExecutionAt(jobTaskBatch.getExecutionAt());
                prepare.setTaskBatchId(jobTaskBatch.getId());
                prepare.setWorkflowTaskBatchId(prepare.getWorkflowTaskBatchId());
                prepare.setWorkflowNodeId(jobTaskBatch.getWorkflowNodeId());
                prepare.setOnlyTimeoutCheck(onlyTimeoutCheck);
                for (JobPrePareHandler prePareHandler : this.prePareHandlers) {
                    if (!prePareHandler.matches(jobTaskBatch.getTaskBatchStatus())) continue;
                    prePareHandler.handler(prepare);
                    break;
                }
                onlyTimeoutCheck = true;
            }
        }
    }
}

