/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.rpc.client.grpc;

import cn.hutool.core.date.StopWatch;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.grpc.auto.GrpcResult;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.util.ClassUtils;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.NetUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.cache.CacheToken;
import com.aizuda.snailjob.server.common.dto.GrpcClientInvokeConfig;
import com.aizuda.snailjob.server.common.dto.InstanceLiveInfo;
import com.aizuda.snailjob.server.common.dto.InstanceSelectCondition;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.rpc.client.RequestMethod;
import com.aizuda.snailjob.server.common.rpc.client.SnailJobRetryListener;
import com.aizuda.snailjob.server.common.rpc.client.annotation.Body;
import com.aizuda.snailjob.server.common.rpc.client.annotation.Header;
import com.aizuda.snailjob.server.common.rpc.client.annotation.Mapping;
import com.aizuda.snailjob.server.common.rpc.client.annotation.Param;
import com.aizuda.snailjob.server.common.rpc.client.grpc.GrpcChannel;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.ManagedChannel;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcClientInvokeHandlerV2
implements InvocationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrpcClientInvokeHandlerV2.class);
    public static final String NEW_INSTANCE_LIVE_INFO = "newInstanceLiveInfo";
    public static final AtomicLong REQUEST_ID = new AtomicLong(0L);
    private InstanceLiveInfo instanceLiveInfo;
    private final boolean failRetry;
    private final int retryTimes;
    private final int retryInterval;
    private final SnailJobRetryListener retryListener;
    private final boolean failover;
    private final Integer routeKey;
    private final String allocKey;
    private final Integer executorTimeout;
    private final boolean async;
    private final String groupName;
    private final String namespaceId;
    private final String targetLabels;

    public GrpcClientInvokeHandlerV2(GrpcClientInvokeConfig config) {
        this.instanceLiveInfo = config.getInstanceLiveInfo();
        RegisterNodeInfo nodeInfo = this.instanceLiveInfo.getNodeInfo();
        this.groupName = nodeInfo.getGroupName();
        this.namespaceId = nodeInfo.getNamespaceId();
        this.failRetry = config.isFailRetry();
        this.retryTimes = config.getRetryTimes();
        this.retryInterval = config.getRetryInterval();
        this.retryListener = config.getRetryListener();
        this.routeKey = config.getRouteKey();
        this.allocKey = config.getAllocKey();
        this.failover = config.isFailover();
        this.executorTimeout = config.getExecutorTimeout();
        this.async = config.isAsync();
        this.targetLabels = config.getTargetLabels();
    }

    public Result invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Mapping annotation = method.getAnnotation(Mapping.class);
        Assert.notNull((Object)annotation, () -> new SnailJobServerException("@Mapping cannot be null"));
        return this.requestRemote(method, args, annotation);
    }

    private Result requestRemote(Method method, Object[] args, Mapping mapping) throws Throwable {
        try {
            ParseParasResult parasResult = this.doParseParams(method, args);
            if (RequestMethod.POST.name().equals(mapping.method().name())) {
                Assert.notNull((Object)parasResult.body, () -> new SnailJobServerException("body cannot be null"));
            }
            Retryer<Result> retryer = this.buildResultRetryer();
            Map<String, String> requestHeaders = parasResult.requestHeaders;
            requestHeaders.put("SJ-TOKEN", CacheToken.get(this.groupName, this.namespaceId));
            Type type = ClassUtils.getReturnType((Method)method);
            long reqId = GrpcClientInvokeHandlerV2.newId();
            Result result = (Result)retryer.call(() -> {
                ListenableFuture<GrpcResult> future;
                RegisterNodeInfo nodeInfo = this.instanceLiveInfo.getNodeInfo();
                StopWatch sw = new StopWatch();
                sw.start("request start " + reqId);
                try {
                    ManagedChannel channel = this.instanceLiveInfo.getChannel();
                    future = GrpcChannel.send(mapping.path(), JsonUtil.toJsonString((Object)args), requestHeaders, reqId, channel);
                }
                finally {
                    sw.stop();
                }
                SnailJobLog.LOCAL.debug("Request complete requestId:[{}] took [{}ms]", new Object[]{reqId, sw.getTotalTimeMillis()});
                if (this.async) {
                    return null;
                }
                Assert.notNull(future, () -> new SnailJobServerException("completableFuture is null"));
                try {
                    GrpcResult grpcResult = (GrpcResult)future.get((long)Optional.ofNullable(this.executorTimeout).orElse(20).intValue(), TimeUnit.SECONDS);
                    Object obj = null;
                    if (StrUtil.isNotBlank((CharSequence)grpcResult.getData())) {
                        obj = JsonUtil.parseObject((String)grpcResult.getData(), (Type)type);
                    }
                    return new Result(grpcResult.getStatus(), grpcResult.getMessage(), obj);
                }
                catch (Exception ex) {
                    log.error("request client I/O error, clientId:[{}] clientAddr:[{}:{}] serverIp:[{}]", new Object[]{nodeInfo.getHostId(), nodeInfo.getHostIp(), nodeInfo.getHostPort(), NetUtil.getLocalIpStr(), ex});
                    InstanceManager instanceManager = (InstanceManager)SnailSpringContext.getBean(InstanceManager.class);
                    this.instanceLiveInfo.setAlive(Boolean.FALSE);
                    this.failoverHandler(nodeInfo, instanceManager);
                    throw ex;
                }
            });
            return result;
        }
        catch (ExecutionException ex) {
            throw ex.getCause();
        }
        catch (Exception ex) {
            Throwable throwable = ex;
            if (ex.getClass().isAssignableFrom(RetryException.class)) {
                RetryException re = (RetryException)ex;
                throwable = re.getLastFailedAttempt().getExceptionCause();
            }
            throw throwable;
        }
    }

    private void failoverHandler(RegisterNodeInfo nodeInfo, InstanceManager instanceManager) {
        if (!this.failover) {
            return;
        }
        InstanceSelectCondition condition = InstanceSelectCondition.builder().allocKey(this.allocKey).routeKey(this.routeKey).namespaceId(nodeInfo.getNamespaceId()).groupName(nodeInfo.getGroupName()).targetLabels(this.targetLabels).build();
        InstanceLiveInfo newInstanceLiveInfo = instanceManager.getALiveInstanceByRouteKey(condition);
        if (newInstanceLiveInfo == null) {
            return;
        }
        this.instanceLiveInfo = newInstanceLiveInfo;
        if (Objects.nonNull(this.retryListener)) {
            Map<String, Object> properties = this.retryListener.properties();
            properties.put(NEW_INSTANCE_LIVE_INFO, this.instanceLiveInfo);
        }
        RegisterNodeInfo newNodeInfo = this.instanceLiveInfo.getNodeInfo();
        log.error("request client I/O error, choose new node clientId:[{}] clientAddr:[{}] serverIp:[{}]", new Object[]{newNodeInfo.getHostId(), newNodeInfo.address(), NetUtil.getLocalIpStr()});
    }

    private Retryer<Result> buildResultRetryer() {
        Retryer retryer = RetryerBuilder.newBuilder().retryIfException(throwable -> this.failRetry).withStopStrategy(StopStrategies.stopAfterAttempt((int)(this.retryTimes <= 0 ? 1 : this.retryTimes))).withWaitStrategy(WaitStrategies.fixedWait((long)Math.max(this.retryInterval, 0), (TimeUnit)TimeUnit.SECONDS)).withRetryListener((RetryListener)this.retryListener).build();
        return retryer;
    }

    private ParseParasResult doParseParams(Method method, Object[] args) {
        Object body = null;
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (parameter.isAnnotationPresent(Body.class)) {
                body = args[i];
                continue;
            }
            if (parameter.isAnnotationPresent(Header.class)) {
                requestHeaders.put("snail-job", JsonUtil.toJsonString((Object)args[i]));
                continue;
            }
            if (parameter.isAnnotationPresent(Param.class)) {
                paramMap.put(parameter.getAnnotation(Param.class).name(), args[i]);
                continue;
            }
            throw new SnailJobServerException("parameter error");
        }
        ParseParasResult parseParasResult = new ParseParasResult();
        parseParasResult.setBody(body);
        parseParasResult.setParamMap(paramMap);
        parseParasResult.setRequestHeaders(requestHeaders);
        return parseParasResult;
    }

    private static long newId() {
        return REQUEST_ID.getAndIncrement();
    }

    private static class ParseParasResult {
        private Object body = null;
        private Map<String, String> requestHeaders;
        private Map<String, Object> paramMap;

        @Generated
        public ParseParasResult() {
        }

        @Generated
        public Object getBody() {
            return this.body;
        }

        @Generated
        public Map<String, String> getRequestHeaders() {
            return this.requestHeaders;
        }

        @Generated
        public Map<String, Object> getParamMap() {
            return this.paramMap;
        }

        @Generated
        public void setBody(Object body) {
            this.body = body;
        }

        @Generated
        public void setRequestHeaders(Map<String, String> requestHeaders) {
            this.requestHeaders = requestHeaders;
        }

        @Generated
        public void setParamMap(Map<String, Object> paramMap) {
            this.paramMap = paramMap;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParseParasResult)) {
                return false;
            }
            ParseParasResult other = (ParseParasResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$body = this.getBody();
            Object other$body = other.getBody();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            Map<String, String> this$requestHeaders = this.getRequestHeaders();
            Map<String, String> other$requestHeaders = other.getRequestHeaders();
            if (this$requestHeaders == null ? other$requestHeaders != null : !((Object)this$requestHeaders).equals(other$requestHeaders)) {
                return false;
            }
            Map<String, Object> this$paramMap = this.getParamMap();
            Map<String, Object> other$paramMap = other.getParamMap();
            return !(this$paramMap == null ? other$paramMap != null : !((Object)this$paramMap).equals(other$paramMap));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParseParasResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            Map<String, String> $requestHeaders = this.getRequestHeaders();
            result = result * 59 + ($requestHeaders == null ? 43 : ((Object)$requestHeaders).hashCode());
            Map<String, Object> $paramMap = this.getParamMap();
            result = result * 59 + ($paramMap == null ? 43 : ((Object)$paramMap).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GrpcClientInvokeHandlerV2.ParseParasResult(body=" + String.valueOf(this.getBody()) + ", requestHeaders=" + String.valueOf(this.getRequestHeaders()) + ", paramMap=" + String.valueOf(this.getParamMap()) + ")";
        }
    }
}

