/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.register;

import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.client.CommonRpcClient;
import com.aizuda.snailjob.server.common.dto.InstanceLiveInfo;
import com.aizuda.snailjob.server.common.dto.UpdateClientInfoDTO;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.register.ServerRegister;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class UpdateClientRegister {
    private final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(2, 4, 1L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1000));
    private final InstanceManager instanceManager;

    public boolean updateClientInfo(UpdateClientInfoDTO clientInfoDTO) {
        if (Objects.isNull(clientInfoDTO)) {
            return false;
        }
        Set<InstanceLiveInfo> instanceALiveInfoSet = this.instanceManager.getInstanceALiveInfoSet("DEFAULT_SERVER_NAMESPACE_ID", "DEFAULT_SERVER");
        instanceALiveInfoSet = instanceALiveInfoSet.stream().filter(info -> !info.getNodeInfo().getHostId().equals(ServerRegister.CURRENT_CID)).collect(Collectors.toSet());
        boolean result = true;
        if (!instanceALiveInfoSet.isEmpty()) {
            ArrayList results = new ArrayList();
            instanceALiveInfoSet.stream().map(info -> this.threadPoolExecutor.submit(() -> {
                CommonRpcClient serverRpcClient = this.buildRpcClient((InstanceLiveInfo)info);
                return serverRpcClient.updateClientInfo(clientInfoDTO);
            })).forEach(future -> {
                try {
                    Result futureResult = (Result)future.get(1L, TimeUnit.SECONDS);
                    if (StatusEnum.NO.getStatus().intValue() == futureResult.getStatus() || Objects.nonNull(futureResult.getData()) && !((Boolean)futureResult.getData()).booleanValue()) {
                        SnailJobLog.LOCAL.error("update client info error. msg:[{}]", new Object[]{futureResult.getMessage()});
                        results.add(false);
                    } else {
                        results.add(true);
                    }
                }
                catch (Throwable e) {
                    SnailJobLog.LOCAL.error("update client info error", new Object[]{e});
                    results.add(false);
                }
            });
            result = results.stream().allMatch(Boolean::booleanValue);
        }
        return result && this.instanceManager.updateInstanceLabels(clientInfoDTO) != false;
    }

    private CommonRpcClient buildRpcClient(InstanceLiveInfo info) {
        int maxRetryTimes = 3;
        return RequestBuilder.newBuilder().nodeInfo(info).failRetry(true).retryTimes(maxRetryTimes).client(CommonRpcClient.class).build();
    }

    @Generated
    public UpdateClientRegister(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }
}

