/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.cache;

import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import lombok.Generated;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CacheGroupScanActor
implements Lifecycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheGroupScanActor.class);
    private static Cache<String, ActorRef> CACHE;

    public static ActorRef get(String groupName, SyetemTaskTypeEnum typeEnum) {
        return (ActorRef)CACHE.getIfPresent((Object)groupName.concat(typeEnum.name()));
    }

    public static void put(String groupName, SyetemTaskTypeEnum typeEnum, ActorRef actorRef) {
        CACHE.put((Object)groupName.concat(typeEnum.name()), (Object)actorRef);
    }

    @Override
    public void start() {
        SnailJobLog.LOCAL.info("CacheGroupScanActor start", new Object[0]);
        CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).build();
    }

    @Override
    public void close() {
        SnailJobLog.LOCAL.info("CacheGroupScanActor stop", new Object[0]);
        CACHE.invalidateAll();
    }

    @Generated
    public CacheGroupScanActor() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheGroupScanActor)) {
            return false;
        }
        CacheGroupScanActor other = (CacheGroupScanActor)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CacheGroupScanActor;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "CacheGroupScanActor()";
    }
}

