/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.allocate.client;

import com.aizuda.snailjob.server.common.ClientLoadBalance;
import com.aizuda.snailjob.server.common.allocate.client.ClientLoadBalanceManager;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientLoadBalanceRound
implements ClientLoadBalance {
    private static final ConcurrentHashMap<String, AtomicInteger> COUNTER = new ConcurrentHashMap();
    private static final int THRESHOLD = 2147473647;
    private static long CACHE_VALID_TIME = 0L;

    @Override
    public String route(String allocKey, TreeSet<String> clientAllAddressSet) {
        if (System.currentTimeMillis() > CACHE_VALID_TIME) {
            COUNTER.clear();
            CACHE_VALID_TIME = System.currentTimeMillis() + 43200000L;
        }
        String[] addressArr = clientAllAddressSet.toArray(new String[0]);
        AtomicInteger next = COUNTER.getOrDefault(allocKey, new AtomicInteger(1));
        String nextClientId = addressArr[next.get() % clientAllAddressSet.size()];
        int nextIndex = next.incrementAndGet();
        if (nextIndex > 2147473647) {
            next = new AtomicInteger(1);
        }
        COUNTER.put(allocKey, next);
        return nextClientId;
    }

    @Override
    public int routeType() {
        return ClientLoadBalanceManager.AllocationAlgorithmEnum.ROUND.getType();
    }
}

