/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.rpc.client;

import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.triple.Pair;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyChannel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyChannel.class);
    private static Bootstrap bootstrap;
    private static ConcurrentHashMap<Pair<String, String>, Channel> CHANNEL_MAP;

    private NettyChannel() {
    }

    public static void setChannel(String hostId, String ip, Channel channel) {
        CHANNEL_MAP.put(Pair.of(hostId, ip), channel);
    }

    public static void removeChannel(Channel channel) {
        CHANNEL_MAP.forEach((key, value) -> {
            if (value.equals(channel)) {
                CHANNEL_MAP.remove(key);
            }
        });
    }

    public static void setBootstrap(Bootstrap bootstrap) {
        NettyChannel.bootstrap = bootstrap;
    }

    public static synchronized void send(String hostId, String hostIp, Integer port, HttpMethod method, String url, String body, HttpHeaders requestHeaders) throws InterruptedException {
        Channel channel = CHANNEL_MAP.get(Pair.of(hostId, hostIp));
        if ((Objects.isNull(channel) || !channel.isActive()) && Objects.isNull(channel = NettyChannel.connect(hostId, hostIp, port))) {
            SnailJobLog.LOCAL.error("send message but channel is null url:[{}] method:[{}] body:[{}] ", new Object[]{url, method, body});
            return;
        }
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, url, Unpooled.wrappedBuffer((byte[])body.getBytes(StandardCharsets.UTF_8)));
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)hostIp).set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)request.content().readableBytes());
        request.headers().setAll(requestHeaders);
        channel.writeAndFlush((Object)request).sync();
    }

    public static Channel connect(String hostId, String ip, Integer port) {
        try {
            ChannelFuture channelFuture = bootstrap.remoteAddress(ip, port.intValue()).connect();
            boolean notTimeout = channelFuture.awaitUninterruptibly(30L, TimeUnit.SECONDS);
            Channel channel = channelFuture.channel();
            if (notTimeout) {
                if (channel != null && channel.isActive()) {
                    SnailJobLog.LOCAL.info("netty client started {} connect to server id:[{}] ip:[{}] channel:[{}]", new Object[]{channel.localAddress(), hostId, ip, channel});
                    NettyChannel.setChannel(hostId, ip, channel);
                    return channel;
                }
                Throwable cause = channelFuture.cause();
                if (cause != null) {
                    NettyChannel.exceptionHandler(cause);
                }
            } else {
                SnailJobLog.LOCAL.warn("connect remote host[{}] timeout {}s", new Object[]{channel.remoteAddress(), 30});
            }
        }
        catch (Exception e) {
            NettyChannel.exceptionHandler(e);
        }
        return null;
    }

    private static void exceptionHandler(Throwable cause) {
        if (cause instanceof ConnectException) {
            SnailJobLog.LOCAL.error("connect error:{}", new Object[]{cause.getMessage()});
        } else if (cause instanceof ClosedChannelException) {
            SnailJobLog.LOCAL.error("connect error:{}", new Object[]{"client has destroy"});
        } else {
            SnailJobLog.LOCAL.error("connect error:", new Object[]{cause});
        }
    }

    static {
        CHANNEL_MAP = new ConcurrentHashMap(16);
    }
}

